/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.jsm.cache;

import cn.ibaijia.jsm.cache.CacheL1;
import cn.ibaijia.jsm.cache.CacheL2;
import cn.ibaijia.jsm.cache.jedis.JedisCmd;
import cn.ibaijia.jsm.cache.jedis.JedisService;
import cn.ibaijia.jsm.utils.JsonUtil;
import cn.ibaijia.jsm.utils.LogUtil;
import cn.ibaijia.jsm.utils.StringUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import java.lang.reflect.Type;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPubSub;

@Component
public class JedisCacheL2
implements CacheL2 {
    private Logger logger = LogUtil.log(this.getClass());
    @Resource
    private JedisService jedisService;
    @Value(value="${jsm.redis.uri}")
    private String uri;
    @Value(value="${jsm.cache.removeOnUpdate:false}")
    private boolean removeOnUpdate;

    @Override
    public void setExpiredListener(final CacheL1 cacheL1) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                JedisCacheL2.this.jedisService.exec(new JedisCmd<Object>(){

                    @Override
                    public Object run(Jedis jedis) throws Exception {
                        String dbIdx = StringUtil.extract("@\\S*?[:\\d+?]/(\\d+)", JedisCacheL2.this.uri, 1);
                        String expiredPattern = String.format("__keyevent@%s__:expired", dbIdx);
                        String setPattern = String.format("__keyevent@%s__:set", dbIdx);
                        ArrayList<String> patterns = new ArrayList<String>();
                        patterns.add(expiredPattern);
                        if (JedisCacheL2.this.removeOnUpdate) {
                            patterns.add(setPattern);
                        }
                        jedis.psubscribe(new JedisPubSub(){

                            public void onPSubscribe(String pattern, int subscribedChannels) {
                                super.onPSubscribe(pattern, subscribedChannels);
                                JedisCacheL2.this.logger.info("onPSubscribe:" + pattern + "|" + subscribedChannels);
                            }

                            public void onPMessage(String pattern, String channel, String message) {
                                super.onPMessage(pattern, channel, message);
                                JedisCacheL2.this.logger.info("onPMessage:" + pattern + "|" + channel + "|" + message);
                                cacheL1.remove(message);
                            }
                        }, patterns.toArray(new String[patterns.size()]));
                        return null;
                    }
                });
            }
        }).start();
    }

    @Override
    public boolean put(String key, int seconds, Object value) {
        try {
            String val = null;
            val = value instanceof String ? (String)value : JsonUtil.toJsonString(value);
            this.jedisService.setex(key, seconds, val);
            return true;
        }
        catch (Exception e) {
            this.logger.error("JedisCacheL2 put error. key:" + key, (Throwable)e);
            return false;
        }
    }

    @Override
    public <T> T get(String key, Class<T> clazz) {
        try {
            String res = this.jedisService.get(key);
            if (StringUtil.isEmpty(res)) {
                return null;
            }
            return JsonUtil.parseObject(res, clazz);
        }
        catch (Exception e) {
            this.logger.error("JedisCacheL2 get error. key:" + key, (Throwable)e);
            return null;
        }
    }

    @Override
    public <T> T get(String key, TypeReference<T> typeReference) {
        try {
            String res = this.jedisService.get(key);
            if (StringUtil.isEmpty(res)) {
                return null;
            }
            return JsonUtil.parseObject(res, typeReference);
        }
        catch (Exception e) {
            this.logger.error("JedisCacheL2 get error. key:" + key, (Throwable)e);
            return null;
        }
    }

    @Override
    public <T> T get(String key, Type type) {
        try {
            String res = this.jedisService.get(key);
            if (StringUtil.isEmpty(res)) {
                return null;
            }
            return JsonUtil.parseObject(res, type);
        }
        catch (Exception e) {
            this.logger.error("JedisCacheL2 get error. key:" + key, (Throwable)e);
            return null;
        }
    }

    @Override
    public String get(String key) {
        try {
            return this.jedisService.get(key);
        }
        catch (Exception e) {
            this.logger.error("JedisCacheL2 get error. key:" + key, (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean remove(String key) {
        try {
            this.jedisService.del(key);
            return true;
        }
        catch (Exception e) {
            this.logger.error("JedisCacheL2 remove error. key:" + key, (Throwable)e);
            return false;
        }
    }
}

