/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.jsm.cache;

import cn.ibaijia.jsm.cache.CacheL1;
import cn.ibaijia.jsm.utils.LogUtil;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class CaffeineCacheL1
implements CacheL1 {
    private Logger logger = LogUtil.log(this.getClass());
    Cache<String, Object> cache;

    public CaffeineCacheL1() {
        this.init();
    }

    private void init() {
        this.cache = Caffeine.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS).initialCapacity(500).maximumSize(2000L).build();
    }

    @Override
    public boolean put(String key, Object value) {
        try {
            this.cache.put((Object)key, value);
            return true;
        }
        catch (Exception e) {
            this.logger.error("CaffeineCacheL1 put error. key:" + key, (Throwable)e);
            return false;
        }
    }

    @Override
    public <T> T get(String key) {
        try {
            return (T)this.cache.getIfPresent((Object)key);
        }
        catch (Exception e) {
            this.logger.error("CaffeineCacheL1 get error. key:" + key, (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean remove(String key) {
        try {
            this.cache.invalidate((Object)key);
            return true;
        }
        catch (Exception e) {
            this.logger.error("CaffeineCacheL1 remove error. key:" + key, (Throwable)e);
            return false;
        }
    }
}

