/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.jsm.cache;

import cn.ibaijia.jsm.cache.CacheL1;
import cn.ibaijia.jsm.cache.CacheL2;
import cn.ibaijia.jsm.context.AppContext;
import cn.ibaijia.jsm.context.service.BaseService;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CacheService
extends BaseService {
    @Resource
    private CacheL1 cacheL1;
    @Resource
    private CacheL2 cacheL2;
    private ThreadPoolExecutor syncThreadPool;

    public void init() {
        Integer threadNumber = AppContext.getAsInteger("cache.service.async.thread", 1);
        this.logger.info("CacheService cacheL2 use async thread number:{}", (Object)threadNumber);
        this.syncThreadPool = new ThreadPoolExecutor((int)threadNumber, (int)threadNumber, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
            byte index = 0;

            @Override
            public Thread newThread(Runnable runnable) {
                this.index = (byte)(this.index + 1);
                return new Thread(runnable, "cache-pool" + this.index);
            }
        });
        this.cacheL2.setExpiredListener(this.cacheL1);
    }

    public void close() {
        if (this.syncThreadPool != null) {
            this.syncThreadPool.shutdown();
        }
    }

    public void remove(String key) {
        this.cacheL1.remove(key);
        this.cacheL1.remove(key);
    }

    public <T> T get(String key, Class<T> clazz) {
        T result = this.getFromL1(key);
        if (result == null) {
            result = this.getFromL2(key, clazz);
            this.logger.debug("getFromL2");
        } else {
            this.logger.debug("getFromL1");
        }
        return result;
    }

    public <T> T get(String key, TypeReference<T> typeReference) {
        T result = this.getFromL1(key);
        if (result == null) {
            result = this.getFromL2(key, typeReference);
            this.logger.debug("getFromL2");
        } else {
            this.logger.debug("getFromL1");
        }
        return result;
    }

    public <T> T get(String key, Type type) {
        T result = this.getFromL1(key);
        if (result == null) {
            result = this.getFromL2(key, type);
            this.logger.debug("getFromL2");
        } else {
            this.logger.debug("getFromL1");
        }
        return result;
    }

    public void set(final String key, final int seconds, final Serializable object) {
        this.cacheL1.put(key, object);
        this.syncThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                CacheService.this.cacheL2.put(key, seconds, object);
            }
        });
    }

    private <T> T getFromL1(String key) {
        return this.cacheL1.get(key);
    }

    private <T> T getFromL2(String key, Class<T> clazz) {
        T value = this.cacheL2.get(key, clazz);
        if (value != null) {
            this.logger.debug("set to l1 key:{}", (Object)key);
            this.cacheL1.put(key, value);
        }
        return value;
    }

    private <T> T getFromL2(String key, TypeReference<T> typeReference) {
        T value = this.cacheL2.get(key, typeReference);
        if (value != null) {
            this.logger.debug("set to l1 key:{}", (Object)key);
            this.cacheL1.put(key, value);
        }
        return value;
    }

    private <T> T getFromL2(String key, Type type) {
        Object value = this.cacheL2.get(key, type);
        if (value != null) {
            this.logger.debug("set to l1 key:{}", (Object)key);
            this.cacheL1.put(key, value);
        }
        return value;
    }

    private void expireListenerForL2() {
        String key = "";
        this.cacheL1.remove(key);
    }

    private void updateListenerForL2() {
        String key = "";
        String value = "";
        this.cacheL1.put(key, value);
    }
}

