/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.jsm.auth;

import cn.ibaijia.jsm.annotation.RestAnn;
import cn.ibaijia.jsm.auth.Auth;
import cn.ibaijia.jsm.context.AppContext;
import cn.ibaijia.jsm.context.JsmConfigurer;
import cn.ibaijia.jsm.context.WebContext;
import cn.ibaijia.jsm.context.session.Session;
import cn.ibaijia.jsm.exception.AuthFailException;
import cn.ibaijia.jsm.exception.NoLoginException;
import cn.ibaijia.jsm.exception.NoPermissionException;
import cn.ibaijia.jsm.utils.DateUtil;
import cn.ibaijia.jsm.utils.EncryptUtil;
import cn.ibaijia.jsm.utils.LogUtil;
import cn.ibaijia.jsm.utils.RequestUtil;
import cn.ibaijia.jsm.utils.StringUtil;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class WebAuth
implements Auth {
    private Logger logger = LogUtil.log(WebAuth.class);

    @Override
    public String checkAuth(HttpServletRequest request, RestAnn resetAnn, boolean isTry) {
        Session session;
        String token;
        if (AppContext.isJedisSession()) {
            String at = RequestUtil.get(request, "at");
            String ht = RequestUtil.get(request, "ht");
            this.logger.debug("checkSession, auth type {},at {}, ht {}", new Object[]{resetAnn.authType(), at, ht});
            token = this.decodeWebToken(at, ht, request);
            if (StringUtil.isEmpty(token)) {
                if (isTry) {
                    return token;
                }
                throw new AuthFailException();
            }
        } else {
            token = (String)WebContext.getRequest().getSession().getAttribute("jsm:session:");
            if (token == null) {
                throw new NoLoginException();
            }
        }
        if ((session = new Session(token)).isExpire()) {
            if (isTry) {
                return token;
            }
            throw new NoLoginException();
        }
        session.live();
        request.setAttribute("jsm:session:attrKey", (Object)session);
        if (!(isTry || StringUtil.isEmpty(resetAnn.permission()) || JsmConfigurer.getWebJsmSecurityService().hasPermission(resetAnn.permission()))) {
            throw new NoPermissionException();
        }
        return token;
    }

    private String decodeWebToken(String at, String ht, HttpServletRequest request) {
        String token = null;
        try {
            if (!StringUtil.isEmpty(at) && !StringUtil.isEmpty(ht)) {
                int expireTime;
                String decAuth = EncryptUtil.base64Decode(at);
                if (decAuth == null || !decAuth.contains("_")) {
                    this.logger.error("illegal auth: {}", (Object)at);
                    return null;
                }
                String[] arr = decAuth.split("_");
                token = arr[0];
                String timestamp = arr[1];
                Long cTime = Long.valueOf(timestamp);
                long sTime = DateUtil.currentTime();
                long res = Math.abs(sTime - cTime);
                if (res > (long)(expireTime = AppContext.getAtExpireTime())) {
                    this.logger.error("sTime {} - cTime {} = {}", new Object[]{sTime, cTime, res});
                    return null;
                }
                String sAuth = EncryptUtil.base64Encode(token + "_" + timestamp);
                if (!sAuth.equals(at)) {
                    this.logger.error("sAt {} != at {}", new Object[]{sAuth, at});
                    return null;
                }
                String sHash = EncryptUtil.md5(token + "_" + timestamp);
                if (!sHash.equals(ht)) {
                    this.logger.error("sHt {} != ht {}", new Object[]{sHash, ht});
                    return null;
                }
            }
            if (AppContext.isDevModel() && StringUtil.isEmpty(token) && !StringUtil.isEmpty(token = RequestUtil.get(request, "jsm-token"))) {
                this.logger.warn("use dev model token:{}", (Object)"jsm-token");
            }
            request.setAttribute("token", token);
        }
        catch (Exception e) {
            this.logger.error("decodeWebToken error!", (Throwable)e);
            return null;
        }
        return token;
    }
}

