/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.jsm.auth;

import cn.ibaijia.jsm.annotation.RestAnn;
import cn.ibaijia.jsm.auth.Auth;
import cn.ibaijia.jsm.cache.CacheService;
import cn.ibaijia.jsm.consts.BasePairConstants;
import cn.ibaijia.jsm.context.AppContext;
import cn.ibaijia.jsm.context.rest.resp.RestResp;
import cn.ibaijia.jsm.exception.AuthFailException;
import cn.ibaijia.jsm.http.HttpClient;
import cn.ibaijia.jsm.oauth.password.OauthContext;
import cn.ibaijia.jsm.utils.LogUtil;
import cn.ibaijia.jsm.utils.RequestUtil;
import cn.ibaijia.jsm.utils.StringUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class PasswordAuth
implements Auth {
    private Logger logger = LogUtil.log(PasswordAuth.class);
    @Resource
    private CacheService cacheService;
    private HttpClient httpClient = new HttpClient();
    private String tokenName;
    private String verifyUrl;

    private String getTokenName() {
        if (this.tokenName == null) {
            this.tokenName = AppContext.get("jsm.oauth.password.tokenName");
        }
        return this.tokenName;
    }

    private String getVerifyUrl() {
        if (this.verifyUrl == null) {
            this.verifyUrl = AppContext.get("jsm.oauth.password.verifyUrl");
        }
        return this.verifyUrl;
    }

    @Override
    public String checkAuth(HttpServletRequest request, RestAnn resetAnn, boolean isTry) {
        String token = RequestUtil.get(request, this.getTokenName());
        if (StringUtil.isEmpty(token)) {
            throw new AuthFailException(BasePairConstants.VERIFY_ERROR, "\u7f3a\u5c11AT");
        }
        String resourceCode = resetAnn.permission();
        boolean res = this.verifyOauthToken(token, resourceCode);
        if (!res) {
            throw new AuthFailException(BasePairConstants.VERIFY_ERROR);
        }
        return token;
    }

    private RestResp<String> getVerifyOauthTokenResult(String accessToken, String resourceCode) {
        try {
            if (StringUtil.isEmpty(this.getVerifyUrl())) {
                this.logger.error("oauth.password.verifyUrl not found, in AppContext!");
                return null;
            }
            ArrayList<Header> headerList = new ArrayList<Header>();
            headerList.add((Header)new BasicHeader(this.getTokenName(), accessToken));
            String res = this.httpClient.get(headerList, this.getVerifyUrl());
            this.logger.debug("res:{}", (Object)res);
            if (StringUtil.isEmpty(res)) {
                this.logger.error("get verify token info empty error.");
                return null;
            }
            RestResp<String> resp = StringUtil.parseObject(res, new TypeReference<RestResp<String>>(){});
            return resp;
        }
        catch (Exception e) {
            this.logger.error("getVerifyOauthTokenResult error:" + this.getVerifyUrl(), (Throwable)e);
            return null;
        }
    }

    private boolean verifyOauthToken(String token, String resourceCode) {
        try {
            String cacheKey = token + "_" + resourceCode;
            RestResp<String> verifyTokenResp = this.cacheService.get(cacheKey, new TypeReference<RestResp<String>>(){});
            if (verifyTokenResp == null) {
                verifyTokenResp = this.getVerifyOauthTokenResult(token, resourceCode);
                if (verifyTokenResp == null || !verifyTokenResp.isOK()) {
                    return false;
                }
                Integer expireTime = AppContext.getAsInteger("jsm.oauth.password.expireIn", 5);
                this.cacheService.set(cacheKey, expireTime, verifyTokenResp);
            }
            OauthContext.setAccessToken(token);
            OauthContext.setVerifyResult((String)verifyTokenResp.result);
            return verifyTokenResp.isOK();
        }
        catch (Exception e) {
            this.logger.error("verifyOauthToken error!", (Throwable)e);
            return false;
        }
    }
}

