/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.jsm.auth;

import cn.ibaijia.jsm.annotation.RestAnn;
import cn.ibaijia.jsm.auth.Auth;
import cn.ibaijia.jsm.context.AppContext;
import cn.ibaijia.jsm.context.JsmConfigurer;
import cn.ibaijia.jsm.context.session.Session;
import cn.ibaijia.jsm.exception.AuthFailException;
import cn.ibaijia.jsm.exception.NoLoginException;
import cn.ibaijia.jsm.exception.NoPermissionException;
import cn.ibaijia.jsm.utils.BlowFishUtil;
import cn.ibaijia.jsm.utils.DateUtil;
import cn.ibaijia.jsm.utils.EncryptUtil;
import cn.ibaijia.jsm.utils.LogUtil;
import cn.ibaijia.jsm.utils.RequestUtil;
import cn.ibaijia.jsm.utils.StringUtil;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class AppAuth
implements Auth {
    private Logger logger = LogUtil.log(AppAuth.class);

    @Override
    public String checkAuth(HttpServletRequest request, RestAnn resetAnn, boolean isTry) {
        Session session;
        String token = "";
        if (AppContext.isJedisSession()) {
            String at = RequestUtil.get(request, "at");
            String ht = RequestUtil.get(request, "ht");
            this.logger.debug("checkSession, auth type {},at {}, ht {}", new Object[]{resetAnn.authType(), at, ht});
            token = this.decodeAppToken(at, ht, request);
            if (StringUtil.isEmpty(token)) {
                if (isTry) {
                    return token;
                }
                throw new AuthFailException();
            }
        }
        if ((session = new Session(token)).isExpire()) {
            if (isTry) {
                return token;
            }
            throw new NoLoginException();
        }
        session.live();
        request.setAttribute("jsm:session:attrKey", (Object)session);
        if (!(isTry || StringUtil.isEmpty(resetAnn.permission()) || JsmConfigurer.getWebJsmSecurityService().hasPermission(resetAnn.permission()))) {
            throw new NoPermissionException();
        }
        return token;
    }

    private String decodeAppToken(String at, String ht, HttpServletRequest request) {
        String token = null;
        try {
            if (!StringUtil.isEmpty(at) && !StringUtil.isEmpty(ht)) {
                int expireTime;
                String decAuth = BlowFishUtil.dec(at);
                if (decAuth == null || !decAuth.contains(",")) {
                    this.logger.error("illegal at: {}", (Object)at);
                    return null;
                }
                String[] arr = decAuth.split(",");
                token = arr[0];
                String timestamp = arr[1];
                Long cTime = Long.valueOf(timestamp);
                long sTime = DateUtil.currentTime();
                long res = Math.abs(sTime - cTime);
                if (res > (long)(expireTime = AppContext.getAtExpireTime())) {
                    this.logger.error("sTime {} - cTime {} = {}", new Object[]{sTime, cTime, res});
                    return null;
                }
                String sAuth = BlowFishUtil.enc(token + "," + timestamp);
                if (!sAuth.equals(at)) {
                    this.logger.error("sAt {} != at {}", new Object[]{sAuth, at});
                    return null;
                }
                String sHash = EncryptUtil.md5(token + "," + timestamp);
                if (!sHash.equals(at)) {
                    this.logger.error("sHt {} != ht {}", new Object[]{sHash, at});
                    return null;
                }
                request.setAttribute("token", (Object)token);
            }
        }
        catch (Exception e) {
            this.logger.error("decodeAppToken error!", (Throwable)e);
            return null;
        }
        return token;
    }
}

