/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.jsm.aop;

import cn.ibaijia.jsm.annotation.AuthType;
import cn.ibaijia.jsm.annotation.OrderAnn;
import cn.ibaijia.jsm.annotation.RestAnn;
import cn.ibaijia.jsm.annotation.Transaction;
import cn.ibaijia.jsm.auth.AppAuth;
import cn.ibaijia.jsm.auth.Auth;
import cn.ibaijia.jsm.auth.WebAuth;
import cn.ibaijia.jsm.cache.jedis.JedisService;
import cn.ibaijia.jsm.consts.BaseConstants;
import cn.ibaijia.jsm.consts.BasePairConstants;
import cn.ibaijia.jsm.consts.Pair;
import cn.ibaijia.jsm.context.AppContext;
import cn.ibaijia.jsm.context.JsmConfigurer;
import cn.ibaijia.jsm.context.SpringContext;
import cn.ibaijia.jsm.context.WebContext;
import cn.ibaijia.jsm.context.dao.model.OptLog;
import cn.ibaijia.jsm.context.rest.order.BaseOrderLine;
import cn.ibaijia.jsm.context.rest.resp.ExcelResp;
import cn.ibaijia.jsm.context.rest.resp.FileResp;
import cn.ibaijia.jsm.context.rest.resp.FreeResp;
import cn.ibaijia.jsm.context.rest.resp.HtmlResp;
import cn.ibaijia.jsm.context.rest.resp.JsonResp;
import cn.ibaijia.jsm.context.rest.resp.RestResp;
import cn.ibaijia.jsm.context.rest.resp.TextResp;
import cn.ibaijia.jsm.context.rest.resp.XmlResp;
import cn.ibaijia.jsm.context.rest.validate.ValidateModel;
import cn.ibaijia.jsm.context.session.Session;
import cn.ibaijia.jsm.context.session.SessionUser;
import cn.ibaijia.jsm.exception.AlarmException;
import cn.ibaijia.jsm.exception.AuthFailException;
import cn.ibaijia.jsm.exception.BaseException;
import cn.ibaijia.jsm.exception.FailedException;
import cn.ibaijia.jsm.license.LicenseService;
import cn.ibaijia.jsm.mybatis.datasource.DynamicDataSourceHolder;
import cn.ibaijia.jsm.stat.JsmOptLogService;
import cn.ibaijia.jsm.stat.model.Alarm;
import cn.ibaijia.jsm.utils.DateUtil;
import cn.ibaijia.jsm.utils.EncryptUtil;
import cn.ibaijia.jsm.utils.IpUtil;
import cn.ibaijia.jsm.utils.JsmFrameUtil;
import cn.ibaijia.jsm.utils.JsonUtil;
import cn.ibaijia.jsm.utils.LogUtil;
import cn.ibaijia.jsm.utils.OptLogUtil;
import cn.ibaijia.jsm.utils.RequestUtil;
import cn.ibaijia.jsm.utils.ResponseUtil;
import cn.ibaijia.jsm.utils.StringUtil;
import cn.ibaijia.jsm.utils.SystemUtil;
import cn.ibaijia.jsm.utils.TemplateUtil;
import cn.ibaijia.jsm.utils.TransactionUtil;
import cn.ibaijia.jsm.utils.ValidateUtil;
import java.lang.reflect.Method;
import javax.annotation.Resource;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@Order(value=2)
@Aspect
@Component
public class RestAop {
    private static Logger logger = LogUtil.log(RestAop.class);
    private PlatformTransactionManager transactionManager;
    @Resource
    private JedisService jedisService;
    @Resource
    private WebAuth webAuth;
    @Resource
    private AppAuth appAuth;
    @Resource
    private LicenseService licenseService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(restAnn)")
    public Object intercept(ProceedingJoinPoint jpt, RestAnn restAnn) throws Throwable {
        Pair<String> resPair;
        logger.debug("RestAop intercept");
        Object result = null;
        Method method = ((MethodSignature)jpt.getSignature()).getMethod();
        OrderAnn orderAnn = method.getAnnotation(OrderAnn.class);
        if (orderAnn != null && !(resPair = this.orderCheck(jpt, orderAnn)).equals(BasePairConstants.ACTIVITY_TURN)) {
            throw new FailedException(resPair);
        }
        boolean useMock = false;
        try {
            boolean outputed;
            if (!AppContext.isDevModel() && this.licenseService != null && !this.licenseService.check()) {
                throw new AuthFailException(BasePairConstants.LICENSE_EXPIRED);
            }
            String jsmMock = RequestUtil.getParameter(WebContext.getRequest(), "jsm-mock");
            if (AppContext.isDevModel() && !StringUtil.isEmpty(jsmMock)) {
                useMock = true;
                String res = JsmFrameUtil.genMockResult(method);
                logger.warn("mock resp:{}", (Object)res);
                Object t = JsonUtil.parseObject(res, method.getGenericReturnType());
                return t;
            }
            if (restAnn.internal() && !IpUtil.isInternalIp(WebContext.getFirstForwardIp())) {
                throw new AuthFailException(BasePairConstants.NET_LIMIT);
            }
            if (!StringUtil.isEmpty(restAnn.ipCheckKey()) && !IpUtil.checkRemoteIp(WebContext.getFirstForwardIp(), restAnn.ipCheckKey())) {
                throw new AuthFailException(BasePairConstants.IP_LIMIT);
            }
            String authId = this.validateAuth(jpt, restAnn);
            this.validateParams(jpt, restAnn);
            this.repeatCheck(jpt, restAnn, authId);
            if (restAnn.sync()) {
                Method method2 = method;
                synchronized (method2) {
                    result = this.process(jpt, restAnn);
                }
            } else {
                result = this.process(jpt, restAnn);
            }
            if (!useMock) {
                this.optLogRecord(restAnn, jpt);
            }
            if (outputed = this.outputResult(result)) {
                result = null;
            }
        }
        catch (Exception e) {
            RestResp errorResp;
            RestResp restResp = errorResp = JsmFrameUtil.dealException(e);
            return restResp;
        }
        finally {
            boolean outputed;
            if (!useMock) {
                this.optLogRecord(restAnn, jpt);
            }
            if (outputed = this.outputResult(result)) {
                result = null;
            }
        }
        return result;
    }

    private Pair<String> orderCheck(ProceedingJoinPoint jpt, OrderAnn orderAnn) {
        String key = orderAnn.productKey();
        key = StringUtil.isEmpty(key) ? JsmFrameUtil.getKey(jpt) : TemplateUtil.formatWithContextVar(key);
        BaseOrderLine orderLine = (BaseOrderLine)SpringContext.getBean(orderAnn.type().t());
        return orderLine.order(key, orderAnn);
    }

    private String validateAuth(ProceedingJoinPoint jpt, RestAnn resetAnn) {
        String authId = null;
        if (resetAnn.authType() != AuthType.NONE) {
            Auth auth = (Auth)SpringContext.getBean(resetAnn.authType().t());
            if (auth == null) {
                logger.error("authBean not found.{}", (Object)resetAnn.authType().t());
            } else {
                logger.debug("authBean:{}", (Object)resetAnn.authType().t());
                authId = auth.checkAuth(WebContext.getRequest(), resetAnn, false);
            }
        } else if (AppContext.isJedisSession()) {
            String at = RequestUtil.get(WebContext.getRequest(), "at");
            String ht = RequestUtil.get(WebContext.getRequest(), "ht");
            String token = RequestUtil.get(WebContext.getRequest(), "jsm-token");
            if ((StringUtil.isEmpty(at) && StringUtil.isEmpty(ht) || AppContext.isDevModel() && !StringUtil.isEmpty(token)) && StringUtil.isEmpty(authId = this.webAuth.checkAuth(WebContext.getRequest(), resetAnn, true))) {
                authId = this.appAuth.checkAuth(WebContext.getRequest(), resetAnn, true);
            }
        }
        return authId;
    }

    private boolean outputResult(Object result) {
        boolean output = true;
        if (result instanceof RestResp) {
            WebContext.getRequest().setAttribute("jsm-resp-code", ((RestResp)result).code);
            if (WebContext.getResponse().getStatus() == 200) {
                WebContext.getResponse().setStatus(JsmConfigurer.getRestStatusStrategy().httpStatusCode((RestResp)result));
            }
            logger.info("resp:" + StringUtil.toJson(result));
            output = false;
        } else {
            try {
                if (result instanceof FileResp) {
                    ResponseUtil.outputFile(WebContext.getResponse(), (FileResp)result);
                } else if (result instanceof TextResp) {
                    ResponseUtil.outputText(WebContext.getResponse(), (TextResp)result);
                } else if (result instanceof JsonResp) {
                    ResponseUtil.outputJson(WebContext.getResponse(), (JsonResp)result);
                } else if (result instanceof XmlResp) {
                    ResponseUtil.outputXml(WebContext.getResponse(), (XmlResp)result);
                } else if (result instanceof HtmlResp) {
                    ResponseUtil.outputHtml(WebContext.getResponse(), (HtmlResp)result);
                } else if (result instanceof ExcelResp) {
                    ResponseUtil.outputExcel(WebContext.getResponse(), (ExcelResp)result);
                } else if (result instanceof FreeResp) {
                    ResponseUtil.outputFreeResp(WebContext.getResponse(), (FreeResp)result);
                } else if (result instanceof String) {
                    String res = (String)result;
                    logger.info("resp: {}", (Object)res);
                    if (res.startsWith("redirect:")) {
                        WebContext.getResponse().sendRedirect(res.substring(9));
                    } else if (res.startsWith("forward:")) {
                        HttpServletRequest request = WebContext.getRequest();
                        HttpServletResponse response = WebContext.getResponse();
                        request.getRequestDispatcher(res.substring(8)).forward((ServletRequest)request, (ServletResponse)response);
                    } else {
                        logger.warn("unknown Resp String!");
                        output = false;
                    }
                } else {
                    output = false;
                }
            }
            catch (Exception e) {
                logger.error("outputResult error.", (Throwable)e);
            }
        }
        return output;
    }

    private void repeatCheck(ProceedingJoinPoint jpt, RestAnn resetAnn, String authId) {
        boolean isRepeat;
        if ((WebContext.isRequestMethod("POST") || WebContext.isRequestMethod("PUT")) && resetAnn.repeatCheck() && (isRepeat = this.isRepeatRequest(jpt, authId))) {
            throw new FailedException(BasePairConstants.REPEAT_REQ_ERROR);
        }
    }

    private void validateParams(ProceedingJoinPoint jpt, RestAnn resetAnn) {
        String message;
        if (resetAnn.validate() && !StringUtil.isEmpty(message = this.validate(jpt))) {
            throw new FailedException(BasePairConstants.PARAMS_ERROR, message);
        }
    }

    private void optLogRecord(RestAnn resetAnn, ProceedingJoinPoint jpt) {
        if (!StringUtil.isEmpty(resetAnn.log())) {
            OptLog optLog = new OptLog();
            optLog.clusterId = AppContext.getClusterId();
            optLog.traceId = WebContext.getTraceId();
            optLog.ip = WebContext.getRemoteIp();
            Session session = WebContext.currentSession();
            optLog.mac = session != null ? (String)session.get("mac") : "";
            optLog.funcName = resetAnn.logType();
            SessionUser sessionUser = WebContext.currentUser();
            if (sessionUser != null) {
                OptLogUtil.setLogUserIfNot((String)WebContext.currentSession().get(BaseConstants.SESSION_USERNAME_KEY));
                optLog.uid = sessionUser.getUid().toString();
            }
            OptLogUtil.setLogContentIfNot(jpt.getArgs());
            optLog.optDesc = TemplateUtil.formatWithContextVar(resetAnn.log());
            optLog.time = DateUtil.currentTime();
            JsmOptLogService logService = SpringContext.getBean(JsmOptLogService.class);
            logService.add(optLog);
        }
    }

    private boolean isRepeatRequest(ProceedingJoinPoint jpt, String authId) {
        Method method = ((MethodSignature)jpt.getSignature()).getMethod();
        Object[] args = jpt.getArgs();
        if (args != null && args.length > 0) {
            for (Object arg : args) {
                if (arg == null || !(arg instanceof ValidateModel)) continue;
                String reqMd5 = EncryptUtil.md5(StringUtil.toJson(arg));
                String res = this.jedisService.setnx(method.getName() + "_" + reqMd5 + "_" + authId, 5, "1");
                if ("OK".equals(res)) continue;
                return true;
            }
        }
        return false;
    }

    private Object process(ProceedingJoinPoint jpt, RestAnn resetAnn) throws Throwable {
        Object result = null;
        TransactionStatus status = null;
        String clusterSyncLock = resetAnn.clusterSyncLock();
        try {
            clusterSyncLock = TemplateUtil.formatWithContextVar(clusterSyncLock);
            if (!StringUtil.isEmpty(clusterSyncLock) && this.jedisService != null) {
                this.jedisService.lock(clusterSyncLock);
            }
            DynamicDataSourceHolder.setDataSource(false);
            if (!resetAnn.transaction().equals((Object)Transaction.NONE)) {
                DynamicDataSourceHolder.setDataSource(resetAnn.transaction().equals((Object)Transaction.READ));
                this.transactionManager = (PlatformTransactionManager)SpringContext.getBean(resetAnn.transManagerName());
                status = this.transactionManager.getTransaction((TransactionDefinition)this.createTransactionDefinition(resetAnn));
                TransactionUtil.setTransactionStatus(status);
            }
            result = jpt.proceed();
            if (status != null && !status.isCompleted()) {
                if (status.isRollbackOnly()) {
                    logger.warn("transaction rollback!");
                    this.transactionManager.rollback(status);
                } else {
                    this.transactionManager.commit(status);
                }
            }
            if (!StringUtil.isEmpty(resetAnn.log())) {
                OptLogUtil.setLogStatusIfNot("\u6210\u529f");
            }
        }
        catch (Exception e) {
            logger.error("process error.", (Throwable)e);
            if (status != null) {
                logger.error("error: transaction rollback!");
                this.transactionManager.rollback(status);
            }
            if (!StringUtil.isEmpty(resetAnn.log())) {
                OptLogUtil.setLogStatusIfNot("\u5931\u8d25");
            }
            if (e instanceof AlarmException) {
                SystemUtil.addAlarm(new Alarm(((AlarmException)e).getName(), ((BaseException)e).getMsg()));
            } else if (e instanceof BaseException) {
                SystemUtil.addAlarm(new Alarm(e.getClass().getSimpleName(), ((BaseException)e).getMsg()));
            } else {
                SystemUtil.addAlarm(new Alarm("RestAop", "Exception," + e.getMessage()));
            }
            throw e;
        }
        finally {
            TransactionUtil.removeTransactionStatus();
            if (!StringUtil.isEmpty(clusterSyncLock) && this.jedisService != null) {
                this.jedisService.unlock(clusterSyncLock);
            }
        }
        return result;
    }

    private String validate(ProceedingJoinPoint jpt) {
        String message = null;
        Object[] args = jpt.getArgs();
        if (args != null && args.length > 0) {
            for (Object arg : args) {
                if (arg == null) continue;
                if (arg instanceof ValidateModel) {
                    logger.info("request arg:{}", (Object)StringUtil.toJson(arg));
                    message = ValidateUtil.validate(arg);
                    if (StringUtil.isEmpty(message)) continue;
                    break;
                }
                logger.info("request arg type:{}", (Object)arg.getClass().getName());
            }
        }
        return message;
    }

    private DefaultTransactionDefinition createTransactionDefinition(RestAnn restAnn) {
        DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
        transactionDefinition.setPropagationBehavior(restAnn.transPropagationBehavior());
        transactionDefinition.setIsolationLevel(restAnn.transIsolationLevel());
        transactionDefinition.setReadOnly(restAnn.transaction().equals((Object)Transaction.READ));
        transactionDefinition.setTimeout(restAnn.transTimeout());
        return transactionDefinition;
    }
}

