/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.jsm.aop;

import cn.ibaijia.jsm.annotation.ClusterLockAnn;
import cn.ibaijia.jsm.cache.jedis.JedisService;
import cn.ibaijia.jsm.utils.JsmFrameUtil;
import cn.ibaijia.jsm.utils.LogUtil;
import cn.ibaijia.jsm.utils.StringUtil;
import cn.ibaijia.jsm.utils.TemplateUtil;
import cn.ibaijia.jsm.utils.TransactionUtil;
import javax.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Order(value=2)
@Aspect
@Component
public class ClusterLockAop {
    private static Logger logger = LogUtil.log(ClusterLockAop.class);
    @Resource
    private JedisService jedisService;

    @Around(value="@annotation(clusterLockAnn)")
    public Object intercept(ProceedingJoinPoint jpt, ClusterLockAnn clusterLockAnn) throws Throwable {
        String key;
        Object result = null;
        if (TransactionUtil.getTransactionStatus() != null) {
            logger.warn("ClusterLockAnn not recommend run in transaction. it's may be make db lock.");
        }
        key = StringUtil.isEmpty(key = clusterLockAnn.value()) ? JsmFrameUtil.getLockKey(jpt) : TemplateUtil.formatWithContextVar(key);
        try {
            logger.debug("clusterLockAnn lock:{}", (Object)key);
            boolean locked = this.jedisService.lock(key);
            if (!locked) {
                logger.error("clusterLockAnn lock:{} failed, return.", (Object)key);
                Object object = result;
                return object;
            }
            result = jpt.proceed();
        }
        catch (Exception e) {
            logger.error("clusterLockAnn error,lock key:" + key);
            throw e;
        }
        finally {
            this.jedisService.unlock(key);
            logger.debug("clusterLockAnn unlock:{}", (Object)key);
        }
        return result;
    }
}

