/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.jsm.aop;

import cn.ibaijia.jsm.annotation.ClusterJobLockAnn;
import cn.ibaijia.jsm.cache.jedis.JedisService;
import cn.ibaijia.jsm.context.AppContext;
import cn.ibaijia.jsm.context.WebContext;
import cn.ibaijia.jsm.stat.model.Alarm;
import cn.ibaijia.jsm.utils.JsmFrameUtil;
import cn.ibaijia.jsm.utils.LogUtil;
import cn.ibaijia.jsm.utils.StringUtil;
import cn.ibaijia.jsm.utils.SystemUtil;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Order(value=1)
@Aspect
@Component
public class ClusterJobLockAop {
    private static Logger logger = LogUtil.log(ClusterJobLockAop.class);
    private AtomicInteger traceIdAi = new AtomicInteger(0);
    @Resource
    private JedisService jedisService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(clusterJobLockAnn)")
    public Object intercept(ProceedingJoinPoint jpt, ClusterJobLockAnn clusterJobLockAnn) throws Throwable {
        Object result = null;
        String key = clusterJobLockAnn.value();
        if (StringUtil.isEmpty(key)) {
            key = JsmFrameUtil.getLockKey(jpt);
        }
        try {
            logger.debug("clusterJobLockAnn lock:{}", (Object)key);
            boolean locked = this.jedisService.lock(key, 0, clusterJobLockAnn.freezeTime());
            if (!locked) {
                logger.warn("clusterJobLockAnn lock:{} failed, return.", (Object)key);
                Object object = result;
                return object;
            }
            int intCount = this.traceIdAi.getAndIncrement();
            if (intCount > 2147483547) {
                this.traceIdAi.set(0);
            }
            WebContext.setTraceId(String.format("job-%s-%s-%s", AppContext.getClusterId(), key, intCount));
            result = jpt.proceed();
        }
        catch (Exception e) {
            logger.error("clusterJobLockAnn error,clusterJobLockAnn key:" + key, (Throwable)e);
            SystemUtil.addAlarm(new Alarm("ClusterJobLockAop", key + ":Exception," + e.getMessage()));
        }
        finally {
            WebContext.clearTraceId();
        }
        return result;
    }
}

