/*
 * Decompiled with CFR 0.152.
 */
package cn.ibaijia.jsm.aop;

import cn.ibaijia.jsm.annotation.CacheAnn;
import cn.ibaijia.jsm.annotation.CacheType;
import cn.ibaijia.jsm.cache.CacheL1;
import cn.ibaijia.jsm.cache.CacheL2;
import cn.ibaijia.jsm.cache.CacheService;
import cn.ibaijia.jsm.utils.JsmFrameUtil;
import cn.ibaijia.jsm.utils.LogUtil;
import cn.ibaijia.jsm.utils.StringUtil;
import cn.ibaijia.jsm.utils.TemplateUtil;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import javax.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Order(value=1)
@Aspect
@Component
public class CacheAop {
    private static Logger logger = LogUtil.log(CacheAop.class);
    @Resource
    private CacheL1 cacheL1;
    @Resource
    private CacheL2 cacheL2;
    @Resource
    private CacheService cacheService;

    @Around(value="@annotation(cacheAnn)")
    public Object intercept(ProceedingJoinPoint jpt, CacheAnn cacheAnn) throws Throwable {
        Object result = null;
        Method method = ((MethodSignature)jpt.getSignature()).getMethod();
        if ("void".equals(method.getReturnType().getName())) {
            return jpt.proceed();
        }
        if (cacheAnn.cacheType().equals((Object)CacheType.L1)) {
            result = this.getFromL1(jpt, cacheAnn);
        } else if (cacheAnn.cacheType().equals((Object)CacheType.L2)) {
            result = this.getFromL2(jpt, cacheAnn);
        } else if (cacheAnn.cacheType().equals((Object)CacheType.BOTH)) {
            result = this.getFromBoth(jpt, cacheAnn);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getFromBoth(ProceedingJoinPoint jpt, CacheAnn cacheAnn) throws Throwable {
        Type returnType;
        String key = cacheAnn.cacheKey();
        key = StringUtil.isEmpty(key) ? JsmFrameUtil.getKey(jpt) : TemplateUtil.formatWithContextVar(key);
        Object result = this.cacheService.get(key, returnType = this.getReturnType(jpt));
        if (result == null) {
            ProceedingJoinPoint proceedingJoinPoint = jpt;
            synchronized (proceedingJoinPoint) {
                result = this.cacheService.get(key, returnType);
                if (result == null) {
                    result = jpt.proceed();
                    if (result != null || cacheAnn.cacheNull()) {
                        this.cacheService.set(key, cacheAnn.expireSeconds(), (Serializable)result);
                    }
                    logger.debug("update cacheService key: " + key);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getFromL2(ProceedingJoinPoint jpt, CacheAnn cacheAnn) throws Throwable {
        String key = cacheAnn.cacheKey();
        key = StringUtil.isEmpty(key) ? JsmFrameUtil.getKey(jpt) : TemplateUtil.formatWithContextVar(key);
        int expireTime = cacheAnn.expireSeconds();
        Type returnType = this.getReturnType(jpt);
        Object result = this.cacheL2.get(key, returnType);
        if (result == null) {
            ProceedingJoinPoint proceedingJoinPoint = jpt;
            synchronized (proceedingJoinPoint) {
                result = this.cacheL2.get(key, returnType);
                if (result == null) {
                    result = jpt.proceed();
                    if (result != null || cacheAnn.cacheNull()) {
                        this.cacheL2.put(key, expireTime, result);
                    }
                    logger.debug("update cacheL2 key: " + key);
                }
            }
        }
        return result;
    }

    private Type getReturnType(ProceedingJoinPoint jpt) {
        Method method = ((MethodSignature)jpt.getSignature()).getMethod();
        return method.getGenericReturnType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getFromL1(ProceedingJoinPoint jpt, CacheAnn cacheAnn) throws Throwable {
        String key = cacheAnn.cacheKey();
        key = StringUtil.isEmpty(key) ? JsmFrameUtil.getKey(jpt) : TemplateUtil.formatWithContextVar(key);
        Object result = this.cacheL1.get(key);
        if (result == null) {
            ProceedingJoinPoint proceedingJoinPoint = jpt;
            synchronized (proceedingJoinPoint) {
                result = this.cacheL1.get(key);
                if (result == null) {
                    result = jpt.proceed();
                    if (result != null || cacheAnn.cacheNull()) {
                        this.cacheL1.put(key, result);
                    }
                    logger.debug("update cacheL1 key: " + key);
                }
            }
        }
        return result;
    }
}

