/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.utils;

import com.jsmframe.context.WebContext;
import com.jsmframe.utils.EncryptUtil;
import com.jsmframe.utils.LogUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class WebUtil {
    private static Logger logger = LogUtil.log(WebUtil.class);

    public static String genToken(String username) {
        return EncryptUtil.md5(username + Math.random() + System.nanoTime());
    }

    public static boolean hasPermissions(String permissionsStr) {
        List<String> permissionList = WebContext.currentPermissions();
        if (permissionList == null) {
            logger.error("user have no permission!");
            return false;
        }
        if (permissionList.contains("SUPER_ADMIN")) {
            return true;
        }
        Boolean resList = false;
        String elsStr = null;
        try {
            SpelExpressionParser parser = new SpelExpressionParser();
            StandardEvaluationContext context = new StandardEvaluationContext();
            context.setVariable("permissions", permissionList);
            elsStr = WebUtil.createExpression(permissionsStr);
            resList = (Boolean)parser.parseExpression(elsStr).getValue((EvaluationContext)context, Boolean.class);
        }
        catch (Exception e) {
            logger.error("permissionsStr {},elsStr {} ", (Object)permissionsStr, elsStr);
        }
        return resList;
    }

    private static String createExpression(String permissions) {
        String pattern = "([0-9a-zA-Z_-]+)";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(permissions);
        String s = m.replaceAll("#permissions?.contains('$1')");
        return s;
    }

    public static void main(String[] args) {
        String str = "1002|BOOK_MANAGEMENT_BREAK|BOOK_MANAGEMENT_SHORT|BOOK_MANAGEMENT_SUPER_SHORT|BOOK_MANAGEMENT_SERVICE";
        String esStr = WebUtil.createExpression(str);
        System.out.println(esStr);
    }
}

