/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.utils;

import com.jsmframe.annotation.EscapeType;
import com.jsmframe.annotation.FieldAnn;
import com.jsmframe.annotation.FieldType;
import com.jsmframe.base.ValidateCallback;
import com.jsmframe.base.ValidateModel;
import com.jsmframe.context.SpringContext;
import com.jsmframe.context.WebContext;
import com.jsmframe.utils.BeanUtil;
import com.jsmframe.utils.HtmlUtil;
import com.jsmframe.utils.LogUtil;
import com.jsmframe.utils.StringUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class ValidateUtil {
    private static Logger logger = LogUtil.log(ValidateUtil.class);
    private static Map<String, ValidateCallback> cbCache = new HashMap<String, ValidateCallback>();

    public static String validate(Object instance) {
        Field[] fields;
        String message = null;
        if (!(instance instanceof ValidateModel)) {
            return null;
        }
        String res = ValidateUtil.checkValidateMethod("validate", (ValidateModel)instance);
        if (!StringUtil.isEmpty(res)) {
            return res;
        }
        String beanName = StringUtil.lowerCaseFirst(instance.getClass().getSimpleName() + "Validator");
        res = ValidateUtil.exeValidateBean(beanName, instance, (ValidateModel)instance);
        if (!StringUtil.isEmpty(res)) {
            return res;
        }
        for (Field field : fields = instance.getClass().getFields()) {
            String regex;
            Object value;
            String name = field.getName();
            FieldAnn fieldAnn = field.getAnnotation(FieldAnn.class);
            if (fieldAnn == null || (value = ValidateUtil.getFieldValue(field, instance)) == null && !fieldAnn.required()) continue;
            if (ValidateModel.class.isAssignableFrom(field.getType())) {
                String msg;
                if (fieldAnn.required() && value == null) {
                    message = SpringContext.getMessage("valid.required", name);
                    return message;
                }
                message = ValidateUtil.checkMore(fieldAnn, instance, field);
                if (!StringUtil.isEmpty(message)) {
                    return message;
                }
                if (value == null || StringUtil.isEmpty(msg = ValidateUtil.validate(value))) continue;
                msg = name + "." + msg;
                return msg;
            }
            if (List.class.isAssignableFrom(field.getType())) {
                List reqList = (List)ValidateUtil.getFieldValue(field, instance);
                if (fieldAnn.required() && (reqList == null || reqList.isEmpty())) {
                    message = SpringContext.getMessage("valid.required", name);
                    return message;
                }
                message = ValidateUtil.checkMore(fieldAnn, instance, field);
                if (!StringUtil.isEmpty(message)) {
                    return message;
                }
                if (reqList == null) continue;
                for (Object req : reqList) {
                    String msg;
                    if (req == null || !ValidateModel.class.isAssignableFrom(req.getClass()) || StringUtil.isEmpty(msg = ValidateUtil.validate(req))) continue;
                    msg = name + "." + msg;
                    return msg;
                }
                continue;
            }
            if (fieldAnn.required() && StringUtil.isEmpty(value)) {
                message = SpringContext.getMessage("valid.required", name);
                return message;
            }
            FieldType type = fieldAnn.type();
            if (!StringUtil.isEmpty(value) && !type.equals((Object)FieldType.ALL)) {
                if (FieldType.NUMBER.equals((Object)type) && !StringUtil.isNumber(value.toString())) {
                    message = SpringContext.getMessage("valid.mustbe", name, type.t());
                    return message;
                }
                if (FieldType.EN_NUMBER.equals((Object)type) && !StringUtil.isEnNum(value.toString())) {
                    message = SpringContext.getMessage("valid.mustbe", name, type.t());
                    return message;
                }
                if (FieldType.CHINESE.equals((Object)type) && !StringUtil.isChinese(value.toString())) {
                    message = SpringContext.getMessage("valid.mustbe", name, type.t());
                    return message;
                }
                if (FieldType.DATE.equals((Object)type) && !StringUtil.isDate(value.toString())) {
                    message = SpringContext.getMessage("valid.mustbe", name, type.t());
                    return message;
                }
                if (FieldType.DATE_TIME.equals((Object)type) && !StringUtil.isDateTime(value.toString())) {
                    message = SpringContext.getMessage("valid.mustbe", name, type.t());
                    return message;
                }
                if (FieldType.EMAIL.equals((Object)type) && !StringUtil.isEmail(value.toString())) {
                    message = SpringContext.getMessage("valid.mustbe", name, type.t());
                    return message;
                }
                if (FieldType.ID_CARD.equals((Object)type) && !StringUtil.isIdcard(value.toString())) {
                    message = SpringContext.getMessage("valid.mustbe", name, type.t());
                    return message;
                }
                if (FieldType.IPV4.equals((Object)type) && !StringUtil.isIpv4(value.toString())) {
                    message = SpringContext.getMessage("valid.mustbe", name, type.t());
                    return message;
                }
                if (FieldType.MOB_NO.equals((Object)type) && !StringUtil.isMobNo(value.toString())) {
                    message = SpringContext.getMessage("valid.mustbe", name, type.t());
                    return message;
                }
                if (FieldType.TEL_NO.equals((Object)type) && !StringUtil.isTelNo(value.toString())) {
                    message = SpringContext.getMessage("valid.mustbe", name, type.t());
                    return message;
                }
                if (FieldType.MONEY.equals((Object)type) && !StringUtil.isMoney(value.toString())) {
                    message = SpringContext.getMessage("valid.mustbe", name, type.t());
                    return message;
                }
                if (FieldType.URL.equals((Object)type) && !StringUtil.isUrl(value.toString())) {
                    message = SpringContext.getMessage("valid.mustbe", name, type.t());
                    return message;
                }
                if (FieldType.BANK_CARD.equals((Object)type) && !StringUtil.isBankCard(value.toString())) {
                    message = SpringContext.getMessage("valid.mustbe", name, type.t());
                    return message;
                }
            }
            if (!StringUtil.isEmpty(regex = fieldAnn.regex()) && value instanceof String && !((String)value).matches(regex)) {
                String msg = SpringContext.getMessage(fieldAnn.message(), new Object[0]);
                message = SpringContext.getMessage("valid.regexLimit", name, msg);
                return message;
            }
            int minLen = fieldAnn.minLen();
            if (minLen != -1 && value instanceof String && ((String)value).length() < minLen) {
                message = SpringContext.getMessage("valid.minLenLimit", name, minLen);
                return message;
            }
            int maxLen = fieldAnn.maxLen();
            if (maxLen != -1 && value instanceof String && ((String)value).length() > maxLen) {
                message = SpringContext.getMessage("valid.maxLenLimit", name, maxLen);
                return message;
            }
            message = ValidateUtil.checkMore(fieldAnn, instance, field);
            if (!StringUtil.isEmpty(message)) {
                return message;
            }
            if (!(value instanceof String)) continue;
            String valueStr = (String)value;
            EscapeType escapeType = fieldAnn.escape();
            if (EscapeType.ALL.equals((Object)escapeType)) {
                ValidateUtil.setFieldValue(field, instance, HtmlUtil.filter(valueStr));
                continue;
            }
            if (EscapeType.CSS.equals((Object)escapeType)) {
                ValidateUtil.setFieldValue(field, instance, HtmlUtil.cssFilter(valueStr));
                continue;
            }
            if (EscapeType.JS.equals((Object)escapeType)) {
                ValidateUtil.setFieldValue(field, instance, HtmlUtil.jsFilter(valueStr));
                continue;
            }
            if (!EscapeType.HTML.equals((Object)escapeType)) continue;
            ValidateUtil.setFieldValue(field, instance, HtmlUtil.htmlFilter(valueStr));
        }
        return message;
    }

    private static String checkMore(FieldAnn fieldAnn, Object instance, Field field) {
        String message = ValidateUtil.checkEl(fieldAnn, instance, field);
        if (!StringUtil.isEmpty(message)) {
            return message;
        }
        message = ValidateUtil.checkValidateBean(fieldAnn, instance, field);
        if (!StringUtil.isEmpty(message)) {
            return message;
        }
        message = ValidateUtil.checkValidateMethod(fieldAnn, instance, field);
        if (!StringUtil.isEmpty(message)) {
            return message;
        }
        return null;
    }

    private static String checkValidateMethod(FieldAnn fieldAnn, Object instance, Field field) {
        String res;
        String validateMethod = fieldAnn.validateMethod();
        String name = field.getName();
        if ("default".equals(validateMethod)) {
            validateMethod = name + "Validate";
        }
        if (!StringUtil.isEmpty(validateMethod) && !StringUtil.isEmpty(res = ValidateUtil.checkValidateMethod(validateMethod, (ValidateModel)instance))) {
            return SpringContext.getMessage("valid.regexLimit", name, res);
        }
        return null;
    }

    private static String checkValidateBean(FieldAnn fieldAnn, Object instance, Field field) {
        String res;
        String cb = fieldAnn.validateBean();
        if (!StringUtil.isEmpty(cb) && !StringUtil.isEmpty(res = ValidateUtil.exeValidateBean(cb, BeanUtil.getFieldValue(field, instance), (ValidateModel)instance))) {
            return SpringContext.getMessage("valid.regexLimit", field.getName(), res);
        }
        return null;
    }

    private static String checkEl(FieldAnn fieldAnn, Object instance, Field field) {
        boolean res;
        String el = fieldAnn.el();
        if (!StringUtil.isEmpty(el) && !(res = ValidateUtil.exeEl(el, instance))) {
            String msg = SpringContext.getMessage(fieldAnn.message(), new Object[0]);
            return SpringContext.getMessage("valid.regexLimit", field.getName(), msg);
        }
        return null;
    }

    private static String checkValidateMethod(String validateMethod, ValidateModel validateModel) {
        try {
            Method method = validateModel.getClass().getMethod(validateMethod, new Class[0]);
            if (method == null) {
                return null;
            }
            return (String)method.invoke((Object)validateModel, new Object[0]);
        }
        catch (Exception e) {
            logger.debug("checkValidateMethod :" + e.getMessage());
            return null;
        }
    }

    private static String exeValidateBean(String cb, Object fieldVal, ValidateModel vm) {
        try {
            ValidateCallback vc = null;
            try {
                vc = (ValidateCallback)SpringContext.getBean(cb);
            }
            catch (Exception e) {
                logger.debug("try get bean failed by name.{}", (Object)cb);
            }
            if (vc != null) {
                return vc.exe(fieldVal, vm);
            }
        }
        catch (Exception e) {
            return "\u9a8c\u8bc1\u5668\u5f02\u5e38:" + cb;
        }
        return null;
    }

    public static boolean exeEl(String el, Object vm) {
        SpelExpressionParser parser = new SpelExpressionParser();
        StandardEvaluationContext context = new StandardEvaluationContext();
        context.setVariable("vm", vm);
        context.setVariable("session", (Object)WebContext.currentSession());
        context.setVariable("request", (Object)WebContext.getRequest());
        String elsStr = ValidateUtil.createExpression(el, vm);
        return (Boolean)parser.parseExpression(elsStr).getValue((EvaluationContext)context, Boolean.class);
    }

    private static String createExpression(String el, Object vm) {
        Pattern p = Pattern.compile("#\\{(.*?)\\}");
        Matcher m = p.matcher(el);
        HashSet<String> vars = new HashSet<String>();
        while (m.find()) {
            vars.add(m.group(1));
        }
        for (String var : vars) {
            String val = (String)BeanUtil.getFieldValue(var, vm);
            if (StringUtil.isEmpty(val)) continue;
            el = el.replaceAll("#\\{" + var + "\\}", val);
        }
        return el;
    }

    private static Object getFieldValue(Field field, Object instance) {
        try {
            return field.get(instance);
        }
        catch (Exception e) {
            logger.error("getFieldValue error!", (Throwable)e);
            return null;
        }
    }

    private static void setFieldValue(Field field, Object instance, Object value) {
        try {
            field.set(instance, value);
        }
        catch (Exception e) {
            logger.error("getFieldValue error!", (Throwable)e);
        }
    }
}

