/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.utils;

import com.jsmframe.utils.LogUtil;
import com.jsmframe.utils.StringUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.Random;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;

public class ValidCodeUtil {
    private static Logger log = LogUtil.log(ValidCodeUtil.class);
    private Random random = new Random();
    private String randAll = "23456789ABCDEFGHJKLMNPQRSTUVWXYZ";
    private String randNumber = "0123456789";
    private String name = "validCode";
    private int width = 80;
    private int height = 26;
    private int lineSize = 40;
    private int num = 4;
    private boolean numberOnly = true;
    private StringBuilder validCode = new StringBuilder();

    public String getValidCode() {
        return this.validCode.toString();
    }

    public ValidCodeUtil(String name, int width, int height, int num) {
        if (!StringUtil.isEmpty(name)) {
            this.name = name;
        }
        if (width != 0) {
            this.width = width;
        }
        if (height != 0) {
            this.height = height;
        }
        if (num != 0) {
            this.num = num;
        }
    }

    public ValidCodeUtil(String name, int width, int height, int num, boolean numberOnly) {
        this(name, width, height, num);
        this.numberOnly = numberOnly;
    }

    private Font getFont() {
        return new Font("Fixedsys", 1, 18);
    }

    private Color getRandColor(int fc, int bc) {
        if (fc > 255) {
            fc = 255;
        }
        if (bc > 255) {
            bc = 255;
        }
        int r = fc + this.random.nextInt(bc - fc - 16);
        int g = fc + this.random.nextInt(bc - fc - 14);
        int b = fc + this.random.nextInt(bc - fc - 18);
        return new Color(r, g, b);
    }

    public BufferedImage getImage(HttpSession session) {
        int i;
        BufferedImage image = new BufferedImage(this.width, this.height, 4);
        Graphics g = image.getGraphics();
        g.fillRect(0, 0, this.width, this.height);
        g.setFont(new Font("Times New Roman", 0, 18));
        g.setColor(this.getRandColor(110, 133));
        for (i = 0; i <= this.lineSize; ++i) {
            this.drowLine(g);
        }
        for (i = 1; i <= this.num; ++i) {
            this.drowString(g, i);
        }
        session.removeAttribute(this.name);
        session.setAttribute(this.name, (Object)this.getValidCode());
        log.debug("validCode:" + this.getValidCode());
        g.dispose();
        return image;
    }

    public BufferedImage getImage() {
        int i;
        BufferedImage image = new BufferedImage(this.width, this.height, 4);
        Graphics g = image.getGraphics();
        g.fillRect(0, 0, this.width, this.height);
        g.setFont(new Font("Times New Roman", 0, 18));
        g.setColor(this.getRandColor(110, 133));
        for (i = 0; i <= this.lineSize; ++i) {
            this.drowLine(g);
        }
        for (i = 1; i <= this.num; ++i) {
            this.drowString(g, i);
        }
        log.debug("validCode:" + this.getValidCode());
        g.dispose();
        return image;
    }

    private void drowString(Graphics g, int i) {
        g.setFont(this.getFont());
        g.setColor(new Color(this.random.nextInt(101), this.random.nextInt(111), this.random.nextInt(121)));
        String rand = this.getRandomChar();
        this.validCode.append(rand);
        g.translate(this.random.nextInt(3), this.random.nextInt(3));
        g.drawString(rand, 13 * i, 16);
    }

    private void drowLine(Graphics g) {
        int x = this.random.nextInt(this.width);
        int y = this.random.nextInt(this.height);
        int xl = this.random.nextInt(13);
        int yl = this.random.nextInt(15);
        g.drawLine(x, y, x + xl, y + yl);
    }

    private String getRandomChar() {
        String str = this.numberOnly ? this.randNumber : this.randAll;
        int num = this.random.nextInt(str.length());
        return String.valueOf(str.charAt(num));
    }
}

