/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.utils;

import com.jsmframe.rest.resp.ExcelResp;
import com.jsmframe.rest.resp.FileResp;
import com.jsmframe.rest.resp.FreeResp;
import com.jsmframe.rest.resp.HtmlResp;
import com.jsmframe.rest.resp.JsonResp;
import com.jsmframe.rest.resp.RestResp;
import com.jsmframe.rest.resp.TextResp;
import com.jsmframe.rest.resp.XmlResp;
import com.jsmframe.utils.EncryptUtil;
import com.jsmframe.utils.LogUtil;
import com.jsmframe.utils.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.Header;
import org.slf4j.Logger;

public class ResponseUtil {
    private static Logger logger = LogUtil.log(ResponseUtil.class);

    public static void outputExcel(HttpServletResponse response, ExcelResp excelResp) {
        logger.info("excelResp:{}", (Object)excelResp.fileName);
        response.setHeader("Content-Disposition", "attachment; filename=" + EncryptUtil.urlEncode(excelResp.fileName));
        response.setContentType("application/octet-stream;charset=UTF-8");
        if (excelResp.workbook != null) {
            try {
                excelResp.workbook.write((OutputStream)response.getOutputStream());
            }
            catch (IOException e) {
                logger.error("write workbook error! {}", (Object)excelResp.fileName);
            }
            finally {
                try {
                    excelResp.workbook.close();
                }
                catch (IOException e) {
                    logger.error("close workbook error! {}", (Object)excelResp.fileName);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void outputXml(HttpServletResponse response, XmlResp xmlResp) {
        logger.info("xmlResp:{}", (Object)xmlResp.xml);
        try (PrintWriter pw = null;){
            response.setContentType("text/xml;charset=UTF-8");
            pw = response.getWriter();
            pw.write(xmlResp.xml);
            pw.flush();
            pw.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void outputHtml(HttpServletResponse response, HtmlResp htmlResp) {
        logger.info("htmlResp:{}", (Object)htmlResp.html);
        try (PrintWriter pw = null;){
            response.setContentType("text/html;charset=UTF-8");
            pw = response.getWriter();
            pw.write(htmlResp.html);
            pw.flush();
            pw.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void outputFreeResp(HttpServletResponse response, FreeResp freeResp) {
        logger.info("freeResp: type:{} content:{}", (Object)freeResp.contentType, (Object)freeResp.content);
        try (PrintWriter pw = null;){
            response.setContentType(freeResp.contentType);
            pw = response.getWriter();
            pw.write(freeResp.content);
            pw.flush();
            pw.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void outputText(HttpServletResponse response, TextResp textResp) {
        logger.info("textResp:{}", (Object)textResp.text);
        try (PrintWriter pw = null;){
            response.setContentType("text/plain;charset=UTF-8");
            pw = response.getWriter();
            pw.write(textResp.text);
            pw.flush();
            pw.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void outputJson(HttpServletResponse response, JsonResp jsonResp) {
        logger.info("jsonResp:{}", (Object)jsonResp.jsonStr);
        try (PrintWriter pw = null;){
            response.setContentType("application/json;charset=UTF-8");
            pw = response.getWriter();
            pw.write(jsonResp.jsonStr);
            pw.flush();
            pw.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void outputFile(HttpServletResponse response, FileResp fileResp) {
        logger.info("FileResp:{}", (Object)fileResp.fileName);
        response.setHeader("Content-Disposition", "attachment; filename=" + EncryptUtil.urlEncode(fileResp.fileName));
        response.setCharacterEncoding("UTF-8");
        if (fileResp.headers != null) {
            for (Header header : fileResp.headers) {
                response.setHeader(header.getName(), header.getValue());
            }
        }
        ServletOutputStream sos = null;
        InputStream is = null;
        PrintWriter pw = null;
        try {
            if (fileResp.outputObject instanceof String) {
                pw = response.getWriter();
                pw.print((String)fileResp.outputObject);
            } else if (fileResp.outputObject instanceof InputStream) {
                sos = response.getOutputStream();
                int offset = 0;
                byte[] bt = new byte[1024];
                is = (InputStream)fileResp.outputObject;
                while ((offset = is.read(bt)) != -1) {
                    sos.write(bt, 0, offset);
                }
            } else {
                pw = response.getWriter();
                pw.print(StringUtil.toJson(fileResp.outputObject));
            }
        }
        catch (Exception e) {
            logger.error("outputFile error!" + fileResp.fileName, (Throwable)e);
        }
        finally {
            try {
                if (sos != null) {
                    sos.flush();
                    sos.close();
                }
                if (is != null) {
                    is.close();
                }
                if (pw != null) {
                    pw.close();
                }
            }
            catch (IOException e) {
                logger.error("outputFile error!" + fileResp.fileName, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void outputRestResp(HttpServletResponse response, RestResp restResp) {
        logger.info("restResp:{}", (Object)restResp);
        try (PrintWriter pw = null;){
            response.setContentType("application/json;charset=UTF-8");
            pw = response.getWriter();
            pw.write(StringUtil.toJson(restResp));
            pw.flush();
            pw.close();
        }
    }
}

