/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.utils;

import com.jsmframe.utils.LogUtil;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerFactory;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;

public class QuartzUtil {
    private static Logger logger = LogUtil.log(QuartzUtil.class);
    private static SchedulerFactory schedulerFactory = new StdSchedulerFactory();

    public static boolean addJob(String jobName, String jobGroupName, String triggerName, String triggerGroupName, Class jobClass, String cron) {
        boolean res = true;
        try {
            Scheduler sched = schedulerFactory.getScheduler();
            JobDetail jobDetail = JobBuilder.newJob((Class)jobClass).withIdentity(jobName, jobGroupName).build();
            if (sched.checkExists(jobDetail.getKey())) {
                logger.error("job key exists!");
                return false;
            }
            TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger();
            triggerBuilder.withIdentity(triggerName, triggerGroupName);
            triggerBuilder.startNow();
            triggerBuilder.withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cron));
            CronTrigger trigger = (CronTrigger)triggerBuilder.build();
            sched.scheduleJob(jobDetail, (Trigger)trigger);
            if (!sched.isShutdown()) {
                sched.start();
            }
        }
        catch (Exception e) {
            logger.error("addJob error!", (Throwable)e);
            res = false;
        }
        return res;
    }

    public static boolean modifyJobTime(String jobName, String jobGroupName, String triggerName, String triggerGroupName, String cron) {
        boolean res = true;
        try {
            Scheduler sched = schedulerFactory.getScheduler();
            TriggerKey triggerKey = TriggerKey.triggerKey((String)triggerName, (String)triggerGroupName);
            CronTrigger trigger = (CronTrigger)sched.getTrigger(triggerKey);
            if (trigger == null) {
                return false;
            }
            String oldTime = trigger.getCronExpression();
            if (!oldTime.equalsIgnoreCase(cron)) {
                TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger();
                triggerBuilder.withIdentity(triggerName, triggerGroupName);
                triggerBuilder.startNow();
                triggerBuilder.withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cron));
                trigger = (CronTrigger)triggerBuilder.build();
                sched.rescheduleJob(triggerKey, (Trigger)trigger);
            }
        }
        catch (Exception e) {
            logger.error("modifyJobTime error!", (Throwable)e);
            res = false;
        }
        return res;
    }

    public static boolean removeJob(String jobName, String jobGroupName, String triggerName, String triggerGroupName) {
        boolean res = true;
        try {
            Scheduler sched = schedulerFactory.getScheduler();
            TriggerKey triggerKey = TriggerKey.triggerKey((String)triggerName, (String)triggerGroupName);
            sched.pauseTrigger(triggerKey);
            sched.unscheduleJob(triggerKey);
            sched.deleteJob(JobKey.jobKey((String)jobName, (String)jobGroupName));
        }
        catch (Exception e) {
            logger.error("removeJob error!", (Throwable)e);
            res = false;
        }
        return res;
    }

    public static boolean startJobs() {
        boolean res = true;
        try {
            Scheduler sched = schedulerFactory.getScheduler();
            sched.start();
        }
        catch (Exception e) {
            logger.error("startJobs error!", (Throwable)e);
            res = false;
        }
        return res;
    }

    public static boolean shutdownJobs() {
        boolean res = true;
        try {
            Scheduler sched = schedulerFactory.getScheduler();
            if (!sched.isShutdown()) {
                sched.shutdown();
            }
        }
        catch (Exception e) {
            logger.error("shutdownJobs error!", (Throwable)e);
            res = false;
        }
        return res;
    }
}

