/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.utils;

import com.jsmframe.context.AppContext;
import com.jsmframe.utils.LogUtil;
import com.jsmframe.utils.ShellUtil;
import com.jsmframe.utils.StringUtil;
import com.jsmframe.utils.SystemUtil;
import org.slf4j.Logger;
import sun.net.util.IPAddressUtil;

public class IpUtil {
    private static Logger logger = LogUtil.log(IpUtil.class);
    private String ENABLE_CMD = "iptables -D INPUT -s %s -j DROP";
    private String DISABLE_CMD = "iptables -I INPUT -s %s -j DROP";

    public static boolean checkRemoteIp(String remoteIp, String contextKey) {
        String ips = AppContext.get(contextKey);
        if (StringUtil.isEmpty(ips)) {
            return false;
        }
        return ips.contains(remoteIp);
    }

    public boolean disableIp(String ip) {
        return this.checkAndExec(ip, this.DISABLE_CMD);
    }

    public boolean enableIp(String ip) {
        return this.checkAndExec(ip, this.ENABLE_CMD);
    }

    private boolean checkAndExec(String ip, String disable_cmd) {
        if (!SystemUtil.IS_OS_UNIX) {
            logger.error("not unix ,can't run shell.");
            return false;
        }
        if (!StringUtil.isIpv4(ip)) {
            logger.error("is not a ip:{}", (Object)ip);
            return false;
        }
        String cmd = String.format(disable_cmd, ip);
        ShellUtil.exec(cmd);
        return true;
    }

    public static boolean isInternalIp(String ip) {
        byte[] addr = IPAddressUtil.textToNumericFormatV4(ip);
        return IpUtil.isInternalIp(addr);
    }

    public static boolean isInternalIp(byte[] addr) {
        byte b0 = addr[0];
        byte b1 = addr[1];
        int SECTION_1 = 10;
        int SECTION_2 = -84;
        int SECTION_3 = 16;
        int SECTION_4 = 31;
        int SECTION_5 = -64;
        int SECTION_6 = -88;
        switch (b0) {
            case 10: {
                return true;
            }
            case -84: {
                if (b1 >= 16 && b1 <= 31) {
                    return true;
                }
            }
            case -64: {
                switch (b1) {
                    case -88: {
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

