/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.utils;

import com.jsmframe.context.WebContext;
import com.jsmframe.exception.BaseException;
import com.jsmframe.utils.FileUtil;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;

public class FtlUtil {
    public static String build(Class<?> clazz, String pathPrefix, Object data, String ftlPath) {
        Configuration config = new Configuration();
        config.setClassForTemplateLoading(clazz, pathPrefix);
        return FtlUtil.build(data, ftlPath, config);
    }

    private static String build(Object data, String ftlPath, Configuration config) {
        try {
            Template template = config.getTemplate(ftlPath);
            template.setEncoding("UTF-8");
            StringWriter writer = new StringWriter();
            template.process(data, (Writer)writer);
            return writer.toString();
        }
        catch (Exception e) {
            throw new BaseException("\u89e3\u6790ftl\u6a21\u677f\u51fa\u9519\uff1a" + ftlPath, e);
        }
    }

    public static void createFile(Class<?> clazz, String pathPrefix, Object data, String ftlFilename, String filename) {
        Configuration config = new Configuration();
        config.setClassForTemplateLoading(clazz, pathPrefix);
        try {
            config.setEncoding(Locale.getDefault(), "UTF-8");
            Template template = config.getTemplate(ftlFilename);
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(FileUtil.createNewFile(filename)), "UTF-8"));
            template.process(data, (Writer)out);
        }
        catch (Exception e) {
            throw new BaseException("\u89e3\u6790ftl\u6a21\u677f\u51fa\u9519\uff1a" + ftlFilename, e);
        }
    }

    public static String build(Object data, String ftlFilename) {
        Configuration config = new Configuration();
        config.setEncoding(Locale.getDefault(), "UTF-8");
        try {
            config.setTemplateLoader((TemplateLoader)new FileTemplateLoader(new File(ftlFilename).getParentFile()));
        }
        catch (IOException e) {
            throw new BaseException("\u89e3\u6790ftl\u6a21\u677f\u51fa\u9519\uff1a" + ftlFilename, e);
        }
        return FtlUtil.build(data, new File(ftlFilename).getName(), config);
    }

    public static String getTagFtl(String ftlName) {
        return WebContext.getRealPath() + "WEB-INF" + File.separator + "tag" + File.separator + ftlName + ".ftl";
    }

    public static String getFormatInfoFtl(String ftlName) {
        return WebContext.getRealPath() + "WEB-INF" + File.separator + "formatInfo" + File.separator + ftlName + ".ftl";
    }

    public static String getWeiXinFtl(String ftlName) {
        return WebContext.getRealPath() + "WEB-INF" + File.separator + "weixin" + File.separator + ftlName + ".ftl";
    }
}

