/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.utils;

import com.jsmframe.exception.BaseException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.status.StatusLogger;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.ResourceUtils;

public class FileUtil {
    private static Logger logger = StatusLogger.getLogger();

    public static InputStream getResourceStream(String filename) {
        try {
            ClassPathResource resource = new ClassPathResource(filename);
            return resource.getInputStream();
        }
        catch (Exception e) {
            logger.warn("file {} not found", (Object)filename);
            throw new BaseException("file not found\uff1a" + filename, e);
        }
    }

    public static File getResource(String filename) {
        try {
            return ResourceUtils.getFile((String)("classpath:" + filename));
        }
        catch (FileNotFoundException e) {
            logger.warn("file {} not found", (Object)filename);
            throw new BaseException("file not found\uff1a" + filename, e);
        }
    }

    public static File createNewFile(String filePath) {
        filePath = filePath.replace('\\', '/').trim();
        new File(filePath.substring(0, filePath.lastIndexOf(47))).mkdirs();
        return new File(filePath);
    }

    public static File getFile(String filename) {
        return new File(filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean zip(String filePath, String zipFileName) {
        logger.info("zip dir:{} to {}", (Object)filePath, (Object)zipFileName);
        ZipOutputStream out = null;
        FilterOutputStream bos = null;
        try {
            out = new ZipOutputStream(new FileOutputStream(zipFileName));
            bos = new BufferedOutputStream(out);
            File sourceFile = new File(filePath);
            FileUtil.compress(out, (BufferedOutputStream)bos, sourceFile);
        }
        catch (Exception e) {
            logger.error("zip error!", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (Exception e) {
                    logger.error("zip close bos error!", (Throwable)e);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {
                    logger.error("zip close out error!", (Throwable)e);
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void compress(ZipOutputStream out, BufferedOutputStream bos, File sourceFile) throws Exception {
        String fileName = sourceFile.getName();
        if (sourceFile.isDirectory()) {
            File[] flist = sourceFile.listFiles();
            if (flist.length == 0) {
                out.putNextEntry(new ZipEntry(fileName + "/"));
            } else {
                for (File file : flist) {
                    FileUtil.compress(out, bos, file);
                }
            }
        } else {
            out.putNextEntry(new ZipEntry(fileName));
            FileInputStream fos = null;
            BufferedInputStream bis = null;
            try {
                int len;
                fos = new FileInputStream(sourceFile);
                bis = new BufferedInputStream(fos);
                while ((len = bis.read()) != -1) {
                    bos.write(len);
                }
            }
            catch (Exception e) {
                logger.error("compress error!", (Throwable)e);
            }
            finally {
                if (bis != null) {
                    bis.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
        }
    }

    public static String readFileAsText(String filePath) {
        return FileUtil.readFileAsText(new File(filePath));
    }

    public static String readFileAsText(File file) {
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            FileReader reader = new FileReader(file);
            BufferedReader br = new BufferedReader(reader);
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\r\n");
            }
        }
        catch (IOException e) {
            logger.error("readFileAsText error.", (Throwable)e);
        }
        return sb.toString();
    }

    public static String readFileAsText(InputStream inputStream) {
        StringBuilder sb = new StringBuilder();
        try {
            IOUtils.readLines((InputStream)inputStream).forEach(line -> sb.append((String)line));
        }
        catch (IOException e) {
            logger.error("readFileAsText error.", (Throwable)e);
        }
        return sb.toString();
    }
}

