/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.utils;

import com.jsmframe.utils.LogUtil;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.slf4j.Logger;

public class FileEncryptUtil {
    private static Logger logger = LogUtil.log(FileEncryptUtil.class);

    public static Key getKey(String strKey) {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("DES");
            keyGenerator.init(new SecureRandom(strKey.getBytes()));
            SecretKey key = keyGenerator.generateKey();
            keyGenerator = null;
            return key;
        }
        catch (Exception e) {
            logger.error("getKey error!", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void encrypt(String file, String destFile, String strKey) {
        InputStream is = null;
        OutputStream out = null;
        CipherInputStream cis = null;
        try {
            int r;
            Key key = FileEncryptUtil.getKey(strKey);
            Cipher cipher = Cipher.getInstance("DES");
            cipher.init(1, key);
            is = new FileInputStream(file);
            out = new FileOutputStream(destFile);
            cis = new CipherInputStream(is, cipher);
            byte[] buffer = new byte[1024];
            while ((r = cis.read(buffer)) > 0) {
                out.write(buffer, 0, r);
            }
        }
        catch (Exception e) {
            logger.error("encrypt error!", (Throwable)e);
        }
        finally {
            try {
                if (cis != null) {
                    cis.close();
                }
                if (is != null) {
                    is.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e1) {
                logger.error("encrypt error!", (Throwable)e1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decrypt(String file, String dest, String strKey) {
        InputStream is = null;
        OutputStream out = null;
        CipherOutputStream cos = null;
        try {
            int r;
            Cipher cipher = Cipher.getInstance("DES");
            Key key = FileEncryptUtil.getKey(strKey);
            cipher.init(2, key);
            is = new FileInputStream(file);
            out = new FileOutputStream(dest);
            cos = new CipherOutputStream(out, cipher);
            byte[] buffer = new byte[1024];
            while ((r = is.read(buffer)) >= 0) {
                cos.write(buffer, 0, r);
            }
        }
        catch (Exception e) {
            logger.error("decrypt error!", (Throwable)e);
        }
        finally {
            try {
                if (cos != null) {
                    cos.close();
                }
                if (is != null) {
                    is.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e1) {
                logger.error("decrypt error!", (Throwable)e1);
            }
        }
    }

    public static void main(String[] args) throws Exception {
    }
}

