/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.utils;

import com.jsmframe.exception.FailedException;
import com.jsmframe.exception.InfoException;
import com.jsmframe.exception.NotFoundException;
import com.jsmframe.pair.Pair;
import com.jsmframe.utils.LogUtil;
import org.slf4j.Logger;

public class ExceptionUtil {
    private static Logger logger = LogUtil.log(ExceptionUtil.class);

    public static void failed(String errorMsg) {
        logger.error(errorMsg);
        throw new FailedException(errorMsg);
    }

    public static void failed(Pair errorPair) {
        logger.error(errorPair.getMessage());
        throw new FailedException(errorPair);
    }

    public static void failed(Pair errorPair, String errorMsg) {
        logger.error(errorMsg);
        throw new FailedException(errorPair, errorMsg);
    }

    public static void notFound(String errorMsg) {
        logger.error(errorMsg);
        throw new NotFoundException(errorMsg);
    }

    public static void notFound(Pair errorPair) {
        logger.error(errorPair.getMessage());
        throw new NotFoundException(errorPair);
    }

    public static void notFound(Pair errorPair, String errorMsg) {
        logger.error(errorMsg);
        throw new NotFoundException(errorPair, errorMsg);
    }

    public static void info(String errorMsg) {
        logger.error(errorMsg);
        throw new InfoException(errorMsg);
    }

    public static void info(Pair errorPair) {
        logger.error(errorPair.getMessage());
        throw new InfoException(errorPair);
    }

    public static void info(Pair errorPair, String errorMsg) {
        logger.error(errorMsg);
        throw new InfoException(errorPair, errorMsg);
    }
}

