/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.utils;

import com.jsmframe.exception.BaseException;
import com.jsmframe.utils.StringUtil;
import com.jsmframe.utils.ThreadLocalUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.status.StatusLogger;

public class DateUtil {
    private static Logger logger = StatusLogger.getLogger();
    public static long TIME_DIFF = 0L;
    public static final long MILLIS_PER_SECOND = 1000L;
    public static final long MILLIS_PER_MINUTE = 60000L;
    public static final long MILLIS_PER_HOUR = 3600000L;
    public static final long MILLIS_PER_DAY = 86400000L;
    public static final String SLASH_DATE_PATTERN = "yyyy/MM/dd";
    public static final String SLASH_TRIM_SECOND_PATTERN = "yyyy/MM/dd HH:mm";
    public static final String SLASH_DATETIME_PATTERN = "yyyy/MM/dd HH:mm:ss";
    public static final String COMPACT_DATE_PATTERN = "yyyyMMdd";
    public static final String COMPACT_TRIM_SECOND_PATTERN = "yyyyMMdd HH:mm";
    public static final String COMPACT_DATETIME_PATTERN = "yyyyMMdd HH:mm:ss";
    public static final String DATE_PATTERN = "yyyy-MM-dd";
    public static final String TRIM_SECOND_PATTERN = "yyyy-MM-dd HH:mm";
    public static final String DATETIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static final String el = "^((\\d{2}(([02468][048])|([13579][26]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))";

    private static SimpleDateFormat getAdf() {
        SimpleDateFormat sdf = ThreadLocalUtil.sdfTL.get();
        if (sdf == null) {
            sdf = new SimpleDateFormat();
            ThreadLocalUtil.sdfTL.set(sdf);
        }
        return sdf;
    }

    public static Date currentDate() {
        Date date = new Date();
        if (TIME_DIFF == 0L) {
            return date;
        }
        return new Date(date.getTime() + TIME_DIFF);
    }

    public static String currentDateStr() {
        return DateUtil.currentDateStr(COMPACT_DATETIME_PATTERN);
    }

    public static String currentDateStr(String pattern) {
        Date date = DateUtil.currentDate();
        return DateUtil.format(date, pattern);
    }

    public static Long currentTime() {
        return DateUtil.currentDate().getTime();
    }

    public static Long currentTimeSecond() {
        return DateUtil.currentTime() / 1000L;
    }

    public static Long toTime(Date date) {
        return date.getTime();
    }

    public static Long toTimeSecond(Date date) {
        return date.getTime() / 1000L;
    }

    public static Date fromTime(String millisOrSeconds) {
        if (StringUtil.isEmpty(millisOrSeconds) || !StringUtil.isNumber(millisOrSeconds)) {
            logger.error("empty or non-number string:{}", (Object)millisOrSeconds);
            return null;
        }
        if (millisOrSeconds.length() == 10) {
            return DateUtil.fromTimeSecond(StringUtil.toLong(millisOrSeconds));
        }
        if (millisOrSeconds.length() == 13) {
            return DateUtil.fromTime(StringUtil.toLong(millisOrSeconds));
        }
        return null;
    }

    public static Date fromTime(Long millis) {
        return new Date(millis);
    }

    public static Date fromTimeSecond(Long second) {
        return new Date(second * 1000L);
    }

    public static String format(Date date, String pattern) {
        if (date == null) {
            return null;
        }
        DateUtil.getAdf().applyPattern(pattern);
        return DateUtil.getAdf().format(date);
    }

    public static Date parse(String strDate, String pattern) {
        DateUtil.getAdf().applyPattern(pattern);
        try {
            return DateUtil.getAdf().parse(strDate);
        }
        catch (ParseException e) {
            logger.error("parse error!", (Throwable)e);
            return null;
        }
    }

    public static Date parse(String strDate) {
        if (StringUtil.isEmpty(strDate)) {
            return null;
        }
        return DateUtil.parse(strDate, DateUtil.getPattern(strDate));
    }

    public static boolean isDate(String strDate) {
        return Pattern.compile(el).matcher(strDate).matches();
    }

    public static String getPattern(String strDate) {
        String[] arr = strDate.split(" ");
        if (arr.length == 1) {
            if (arr[0].split("-").length == 3) {
                return DATE_PATTERN;
            }
            return COMPACT_DATE_PATTERN;
        }
        if (arr.length == 2) {
            if (arr[0].split("-").length == 3) {
                if (arr[1].split(":").length == 2) {
                    return TRIM_SECOND_PATTERN;
                }
                return DATETIME_PATTERN;
            }
            if (arr[1].split(":").length == 2) {
                return COMPACT_TRIM_SECOND_PATTERN;
            }
            return COMPACT_DATETIME_PATTERN;
        }
        throw new BaseException("\u975e\u6cd5\u65e5\u671f\u683c\u5f0f\uff01");
    }

    public static boolean oneDayAgo(Date date) {
        return DateUtil.currentTime() - date.getTime() > 86400000L;
    }

    public static boolean oneHourAgo(Date date) {
        return DateUtil.currentTime() - date.getTime() > 3600000L;
    }

    public static Calendar parseCalendar(String dateStr, String pattern) {
        Calendar c = Calendar.getInstance();
        c.setTime(DateUtil.parse(dateStr, pattern));
        return c;
    }

    public static Date parse(Long date) {
        if (date == null) {
            return null;
        }
        return new Date(date);
    }

    public static String format(Calendar c, String pattern) {
        if (c == null) {
            return null;
        }
        return new SimpleDateFormat(pattern).format(c.getTime());
    }

    public static String format(Date date) {
        if (date == null) {
            return null;
        }
        return new SimpleDateFormat(DATE_PATTERN).format(date);
    }

    public static int dayInWeek(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(7);
    }

    public static int dayInWeekForUse(Date date) {
        int res = DateUtil.dayInWeek(date) - 1;
        return res == 0 ? 7 : res;
    }

    public static int dayInMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(5);
    }

    public static Date addDay(Date date, int amount) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(5, amount);
        return c.getTime();
    }

    public static Date addMinute(Date date, int amount) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(12, amount);
        return c.getTime();
    }

    public static Date addSecond(Date date, int amount) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(13, amount);
        return c.getTime();
    }

    public static Date addMilliSecond(Date date, int amount) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(14, amount);
        return c.getTime();
    }

    public static boolean isSameDay(Date date, Date other) {
        return DateUtil.format(date).equals(DateUtil.format(other));
    }

    public static long reduce(Date startDate, Date endDate, long timeType) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(startDate);
        c2.setTime(endDate);
        long result = c1.getTimeInMillis() - c2.getTimeInMillis();
        return result / timeType;
    }

    public static Date dayOfEnd(Date date) {
        Calendar c1 = Calendar.getInstance();
        c1.setTime(date);
        c1.set(11, 23);
        c1.set(12, 59);
        c1.set(13, 59);
        c1.set(14, 0);
        return c1.getTime();
    }

    public static Date dayOfBegin(Date date) {
        Calendar c1 = Calendar.getInstance();
        c1.setTime(date);
        c1.set(11, 0);
        c1.set(12, 0);
        c1.set(13, 0);
        c1.set(14, 0);
        return c1.getTime();
    }

    public static Date addMonth(Date date, int amount) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(2, amount);
        return c.getTime();
    }

    public static Date setDay(Date date, int amount) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, amount);
        return c.getTime();
    }

    public static Date setMonth(Date date, int amount) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(2, amount);
        return c.getTime();
    }

    public static Date setYear(Date date, int amount) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(1, amount);
        return c.getTime();
    }

    public static int getYear(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(1);
    }

    public static int getMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(2);
    }
}

