/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.swagger;

import com.jsmframe.context.AppContext;
import com.jsmframe.utils.LogUtil;
import com.jsmframe.utils.StringUtil;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Parameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@EnableWebMvc
@EnableSwagger2
@Configuration
public class SwaggerConfig
extends WebMvcConfigurationSupport {
    protected Logger logger = LogUtil.log(((Object)((Object)this)).getClass());
    private boolean swaggerEnable = StringUtil.toBoolean(AppContext.get("swagger.enable"));
    private String swaggerPackage = AppContext.get("swagger.apis.package");
    private String swaggerTitle = AppContext.get("swagger.apis.title");
    private String swaggerVersion = AppContext.get("swagger.apis.version");
    private String swaggerDescription = AppContext.get("swagger.apis.description");
    private String swaggerHeaders = AppContext.get("swagger.apis.headers");

    @Bean
    public Docket createRestApi() {
        this.logger.info("swaggerEnable:{} ", (Object)this.swaggerEnable);
        this.logger.info("swaggerPackage:{} ", (Object)this.swaggerPackage);
        this.logger.info("swaggerTitle:{} ", (Object)this.swaggerTitle);
        this.logger.info("swaggerVersion:{} ", (Object)this.swaggerVersion);
        this.logger.info("swaggerDescription:{} ", (Object)this.swaggerDescription);
        this.logger.info("swaggerHeaders:{} ", (Object)this.swaggerHeaders);
        ApiInfo apiInfo = this.apiInfo();
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        params.add(new Parameter("jsm_mock", "", "", false, false, (ModelReference)new ModelRef("String"), null, null, "query", null, false, null));
        if (!StringUtil.isEmpty(this.swaggerHeaders)) {
            String[] headersArr;
            for (String header : headersArr = this.swaggerHeaders.split(";")) {
                String[] headeArr = header.split("\\|");
                params.add(new Parameter(headeArr[0], "", "", false, false, (ModelReference)new ModelRef("String"), null, null, "header", null, false, null));
            }
        }
        return new Docket(DocumentationType.SWAGGER_2).apiInfo(apiInfo).enable(this.swaggerEnable).globalOperationParameters(params).select().apis(RequestHandlerSelectors.basePackage((String)this.swaggerPackage)).paths(PathSelectors.any()).build();
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder().title(this.swaggerTitle).version(this.swaggerVersion).description(this.swaggerDescription).build();
    }
}

