/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.service;

import com.alibaba.fastjson.JSON;
import com.googlecode.htmlcompressor.compressor.HtmlCompressor;
import com.jsmframe.annotation.FieldAnn;
import com.jsmframe.base.BaseService;
import com.jsmframe.base.ValidateModel;
import com.jsmframe.context.AppContext;
import com.jsmframe.dao.mapper.DbMapper;
import com.jsmframe.dao.model.ApiInfo;
import com.jsmframe.dao.model.ControllerInfo;
import com.jsmframe.dao.model.CreateTableInfo;
import com.jsmframe.dao.model.FieldInfo;
import com.jsmframe.dao.model.Page;
import com.jsmframe.utils.ClassUtil;
import com.jsmframe.utils.FileUtil;
import com.jsmframe.utils.FtlUtil;
import com.jsmframe.utils.JsmFrameUtil;
import com.jsmframe.utils.StringUtil;
import com.jsmframe.utils.XmlUtil;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Service
public class GenService
extends BaseService {
    @Resource
    private DbMapper dbMapper;
    private List<String> parentClazzList = new ArrayList<String>();

    public void genAll() {
        List<String> tableNameList = this.dbMapper.showTables();
        for (String tableName : tableNameList) {
            if (tableName.equals("opt_log_t")) {
                this.logger.debug("ignore jsm frame table. opt_log_t");
                continue;
            }
            this.gen(tableName, false, true);
        }
    }

    public void gen(String tableName) {
        this.gen(tableName, false, true);
    }

    public void gen(String tableName, boolean override) {
        this.gen(tableName, override, true);
    }

    public void gen(String tableName, boolean override, boolean update) {
        File serviceDir;
        File mapperXmlDir;
        File mapperDir;
        String baseJavaDir = null;
        String mapperXmlDirPath = null;
        try {
            baseJavaDir = new File("").getCanonicalPath() + File.separator + "src" + File.separator + "main" + File.separator + "java" + File.separator;
            mapperXmlDirPath = new File("").getCanonicalPath() + File.separator + "src" + File.separator + "main" + File.separator + "resources" + File.separator + "mappers" + File.separator;
        }
        catch (IOException e) {
            this.logger.error("", (Throwable)e);
        }
        String modelPackageName = AppContext.get("gen.model.package.name");
        String mapperPackageName = AppContext.get("gen.mapper.package.name");
        String servicePackageName = AppContext.get("gen.service.package.name");
        this.logger.info("baseJavaDir:{}", baseJavaDir);
        this.logger.info("modelPackageName:{}", (Object)modelPackageName);
        this.logger.info("mapperPackageName:{}", (Object)mapperPackageName);
        this.logger.info("mapperXmlDirPath:{}", mapperXmlDirPath);
        this.logger.info("servicePackageName:{}", (Object)servicePackageName);
        String mapperFtl = "mapper.ftl";
        String mapperXmlFtl = "mapperXml.ftl";
        String modelFtl = "model.ftl";
        String serviceFtl = "service.ftl";
        this.logger.info("mapperFtl:{}", (Object)mapperFtl);
        this.logger.info("mapperXmlFtl:{}", (Object)mapperXmlFtl);
        this.logger.info("modelFtl:{}", (Object)modelFtl);
        this.logger.info("serviceFtl:{}", (Object)serviceFtl);
        String modelDirPath = baseJavaDir + modelPackageName.replace(".", File.separator);
        String mapperDirPath = baseJavaDir + mapperPackageName.replace(".", File.separator);
        String serviceDirPath = baseJavaDir + servicePackageName.replace(".", File.separator);
        File modelDir = new File(modelDirPath);
        if (!modelDir.exists()) {
            this.logger.info("mkdir:{}", (Object)modelDir);
            modelDir.mkdirs();
        }
        if (!(mapperDir = new File(mapperDirPath)).exists()) {
            this.logger.info("mkdir:{}", (Object)mapperDir);
            mapperDir.mkdirs();
        }
        if (!(mapperXmlDir = new File(mapperXmlDirPath)).exists()) {
            this.logger.info("mkdir:{}", (Object)mapperXmlDir);
            mapperXmlDir.mkdirs();
        }
        if (!(serviceDir = new File(serviceDirPath)).exists()) {
            this.logger.info("mkdir:{}", (Object)serviceDir);
            serviceDir.mkdirs();
        }
        String className = this.tableNameToModelName(tableName);
        String modelFileName = modelDirPath + File.separator + className + ".java";
        String mapperFileName = mapperDirPath + File.separator + className + "Mapper.java";
        String mapperXmlFileName = mapperXmlDir + File.separator + className + "Mapper.xml";
        String serviceFileName = serviceDir + File.separator + className + "Service.java";
        HashMap<String, Object> datas = new HashMap<String, Object>();
        datas.put("modelPackageName", modelPackageName);
        datas.put("mapperPackageName", mapperPackageName);
        datas.put("servicePackageName", servicePackageName);
        datas.put("tableName", tableName);
        datas.put("className", className);
        List<FieldInfo> fieldList = this.getTableFieldInfo(tableName, datas);
        datas.put("fieldList", fieldList);
        String modelStr = FtlUtil.build(this.getClass(), "/META-INF/ftl/", datas, modelFtl);
        boolean modelRes = this.writeFile(modelStr, modelFileName, override);
        if (!modelRes && update) {
            this.updateModel(modelStr, modelFileName);
        }
        this.logger.info("createModel:{} res:{}", (Object)modelFileName, (Object)modelRes);
        String mapperStr = FtlUtil.build(this.getClass(), "/META-INF/ftl/", datas, mapperFtl);
        boolean mapperRes = this.writeFile(mapperStr, mapperFileName, override);
        this.logger.info("createMapper:{} res:{}", (Object)mapperFileName, (Object)mapperRes);
        if (!modelRes && update) {
            this.updateMapper(mapperStr, mapperFileName);
            this.updateMapperXml(mapperXmlFileName);
        }
        String mapperXmlStr = FtlUtil.build(this.getClass(), "/META-INF/ftl/", datas, mapperXmlFtl);
        boolean mapperXmlRes = this.writeFile(mapperXmlStr, mapperXmlFileName, override);
        this.logger.info("createMapperXml:{} res:{}", (Object)mapperXmlFileName, (Object)mapperXmlRes);
        String serviceStr = FtlUtil.build(this.getClass(), "/META-INF/ftl/", datas, serviceFtl);
        boolean serviceRes = this.writeFile(serviceStr, serviceFileName, override);
        this.logger.info("createService:{} res:{}", (Object)serviceFileName, (Object)serviceRes);
    }

    private void updateMapperXml(String mapperXmlFileName) {
        String oldStr = FileUtil.readFileAsText(mapperXmlFileName);
        String addRegex = "(<insert id=\"add\"[\\s\\S]*?</insert>)";
        String addBatchRegex = "(<insert id=\"addBatch\"[\\s\\S]*?</insert>)";
        String updateRegex = "(<update id=\"update\"[\\s\\S]*?</update>)";
        String findByIdRegex = "(<select id=\"findById\"[\\s\\S]*?</select>)";
        String findByIdForUpdateRegex = "(<select id=\"findByIdForUpdate\"[\\s\\S]*?</select>)";
        String deleteByIdRegex = "(<delete id=\"deleteById\"[\\s\\S]*?</delete>)";
        String listAllRegex = "(<select id=\"listAll\"[\\s\\S]*?</select>)";
        oldStr = this.clearOldCode(oldStr, addRegex);
        oldStr = this.clearOldCode(oldStr, addBatchRegex);
        oldStr = this.clearOldCode(oldStr, updateRegex);
        oldStr = this.clearOldCode(oldStr, findByIdRegex);
        oldStr = this.clearOldCode(oldStr, findByIdForUpdateRegex);
        oldStr = this.clearOldCode(oldStr, deleteByIdRegex);
        oldStr = this.clearOldCode(oldStr, listAllRegex);
        boolean res = this.writeFile(oldStr, mapperXmlFileName, true);
        this.logger.info("updateMapperXml:{} res:{}", (Object)mapperXmlFileName, (Object)res);
    }

    private String clearOldCode(String oldStr, String addRegex) {
        String oldAdd = this.findElement(oldStr, addRegex);
        if (oldAdd != null) {
            oldStr = oldStr.replace(oldAdd, "");
        }
        return oldStr;
    }

    private void updateMapper(String mapperStr, String mapperFileName) {
        String oldStr = FileUtil.readFileAsText(mapperFileName);
        String addReplace = "((\\s.*?)@Insert[^;]*?add\\([\\s\\S]*?\\);)";
        String addUpdate = "((\\s.*?)(int.*?)(add\\()(.*?)\\);)";
        String addBatchReplace = "((\\s.*?)@Insert[^;]*?addBatch\\([\\s\\S]*?\\);)";
        String addBatchUpdate = "((\\s.*?)(int.*?)(addBatch\\()(.*?)\\);)";
        String updateReplace = "((\\s.*?)@Update([^;]*?update\\()[\\s\\S]*?\\);)";
        String updateUpdate = "((\\s.*?)(int.*?)(update\\()(.*?)\\);)";
        String findByIdReplace = "((\\s.*?)@Select([^;]*?findById\\()[\\s\\S]*?\\);)";
        String findByIdUpdate = "((\\s.*?)(findById\\()(.*?)\\);)";
        String findByIdForUpdateReplace = "((\\s.*?)@Select([^;]*?findByIdForUpdate\\()[\\s\\S]*?\\);)";
        String findByIdForUpdateUpdate = "((\\s.*?)(findByIdForUpdate\\()(.*?)\\);)";
        String deleteByIdReplace = "((\\s.*?)@Delete([^;]*?deleteById\\()[\\s\\S]*?\\);)";
        String deleteByIdUpdate = "((\\s.*?)(deleteById\\()(.*?)\\);)";
        String listAllReplace = "((\\s.*?)@Select[^;]*?listAll\\([\\s\\S]*?\\);)";
        String listAllUpdate = "((\\s.*?)(listAll\\()(.*?)\\);)";
        String oldPackageName = "org.apache.ibatis.annotations.Param;";
        String newPackageName = "org.apache.ibatis.annotations.*;";
        StringBuilder newSb = new StringBuilder();
        oldStr = this.replaceByRegex(mapperStr, oldStr, addReplace, addUpdate, newSb);
        oldStr = this.replaceByRegex(mapperStr, oldStr, addBatchReplace, addBatchUpdate, newSb);
        oldStr = this.replaceByRegex(mapperStr, oldStr, updateReplace, updateUpdate, newSb);
        oldStr = this.replaceByRegex(mapperStr, oldStr, findByIdReplace, findByIdUpdate, newSb);
        oldStr = this.replaceByRegex(mapperStr, oldStr, findByIdForUpdateReplace, findByIdForUpdateUpdate, newSb);
        oldStr = this.replaceByRegex(mapperStr, oldStr, deleteByIdReplace, deleteByIdUpdate, newSb);
        oldStr = this.replaceByRegex(mapperStr, oldStr, listAllReplace, listAllUpdate, newSb);
        oldStr = oldStr.replace(oldPackageName, newPackageName);
        if (newSb.length() > 0) {
            int idx = oldStr.indexOf("{");
            StringBuilder fileSb = new StringBuilder();
            fileSb.append(oldStr.substring(0, idx + 2));
            fileSb.append("\n\n\t").append((CharSequence)newSb);
            fileSb.append(oldStr.substring(idx + 2));
            oldStr = fileSb.toString();
        }
        boolean res = this.writeFile(oldStr, mapperFileName, true);
        this.logger.info("updateMapper:{} res:{}", (Object)mapperFileName, (Object)res);
    }

    private String replaceByRegex(String mapperStr, String oldStr, String addReplace, String addUpdate, StringBuilder newSb) {
        String addReplaceStrOld = this.findElement(oldStr, addReplace);
        String addReplaceStrNew = this.findElement(mapperStr, addReplace);
        if (addReplaceStrOld == null) {
            String addUpdateStrOld = this.findElement(oldStr, addUpdate);
            if (addUpdateStrOld == null) {
                newSb.append(addReplaceStrNew).append("\n");
            } else {
                oldStr = oldStr.replace(addUpdateStrOld, addReplaceStrNew);
            }
        } else {
            oldStr = oldStr.replace(addReplaceStrOld, addReplaceStrNew);
        }
        return oldStr;
    }

    private String findElement(String content, String regex) {
        return this.findElement(content, regex, 1);
    }

    private String findElement(String content, String regex, int idx) {
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(content);
        while (m.find()) {
            if (idx <= m.groupCount()) {
                return m.group(idx);
            }
            this.logger.error("idx:{} > groupCount:{}", (Object)idx, (Object)m.groupCount());
        }
        return null;
    }

    private List<String> findElements(String content, String regex) {
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(content);
        ArrayList<String> list = new ArrayList<String>();
        while (m.find()) {
            list.add(m.group());
        }
        return list;
    }

    private void updateModel(String modelStr, String modelFileName) {
        String oldStr = FileUtil.readFileAsText(modelFileName);
        String newStr = modelStr.substring(modelStr.indexOf("serialVersionUID"));
        String[] fieldArr = newStr.split(";");
        if (fieldArr.length < 1) {
            return;
        }
        StringBuilder newSb = new StringBuilder();
        for (int i = 1; i < fieldArr.length; ++i) {
            String filedDesc;
            String fieldStr = fieldArr[i];
            String[] arr = fieldStr.split("public ");
            if (arr.length != 2 || oldStr.contains(filedDesc = "public " + arr[1])) continue;
            newSb.append(fieldStr).append(";");
        }
        if (newSb.length() > 0) {
            oldStr = oldStr.substring(0, oldStr.lastIndexOf(125));
            oldStr = oldStr + newSb.toString() + "\n}";
            boolean res = this.writeFile(oldStr, modelFileName, true);
            this.logger.info("updateModel:{} res:{}", (Object)modelFileName, (Object)res);
        }
    }

    private boolean writeXmlFile(Document doc, String mapperXmlFileName) {
        try {
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding("UTF-8");
            FileOutputStream output = new FileOutputStream(new File(mapperXmlFileName));
            XMLWriter writer = new XMLWriter((OutputStream)output, format);
            writer.write(doc);
            writer.flush();
            writer.close();
            return true;
        }
        catch (Exception e) {
            this.logger.error("writeXmlFile error.", (Throwable)e);
            return false;
        }
    }

    private void updateOneElement(Element newRoot, Element oldRoot, String elementName, String attrName, String attrVal) {
        Element newAddElement = XmlUtil.find(newRoot, elementName, attrName, attrVal);
        Element oldAddElement = XmlUtil.find(oldRoot, elementName, attrName, attrVal);
        if (oldAddElement != null) {
            oldRoot.remove(oldAddElement);
            oldRoot.add(newAddElement.createCopy());
        } else {
            oldRoot.add(newAddElement.createCopy());
        }
    }

    public void genApiHtml(Class clazz) {
        ArrayList<ControllerInfo> controllerInfoList = new ArrayList<ControllerInfo>();
        ControllerInfo controllerInfo = new ControllerInfo();
        String name = StringUtil.humpToMiddleLine(clazz.getSimpleName());
        if (name.startsWith("-")) {
            name = name.substring(1);
        }
        controllerInfo.name = name = "/" + name + "/";
        controllerInfo.apiInfos = this.getApiInfoList(clazz);
        controllerInfoList.add(controllerInfo);
        this.genApiHtml(controllerInfoList);
    }

    public void genApiHtml() {
        String restPackageName = AppContext.get("gen.rest.package.name");
        Set<Class<?>> classSet = ClassUtil.loadClass(restPackageName, true);
        ArrayList<ControllerInfo> controllerInfoList = new ArrayList<ControllerInfo>();
        for (Class<?> clazz : classSet) {
            RestController restController = clazz.getAnnotation(RestController.class);
            if (restController == null) continue;
            ControllerInfo controllerInfo = new ControllerInfo();
            String name = StringUtil.humpToMiddleLine(clazz.getSimpleName());
            if (name.startsWith("-")) {
                name = name.substring(1);
            }
            controllerInfo.name = name = "/" + name + "/";
            controllerInfo.apiInfos = this.getApiInfoList(clazz);
            controllerInfoList.add(controllerInfo);
        }
        this.genApiHtml(controllerInfoList);
    }

    private void genApiHtml(List<ControllerInfo> controllerInfoList) {
        String apiHtml = "apiHtml.ftl";
        String apiHtmlPath = "";
        boolean isInSpringBoot = this.checkIsInSpringBoot();
        if (StringUtil.isEmpty(apiHtmlPath)) {
            StringBuilder sb = new StringBuilder();
            try {
                sb.append(new File("").getCanonicalPath()).append(File.separator);
            }
            catch (IOException e) {
                this.logger.error("", (Throwable)e);
            }
            sb.append("src").append(File.separator);
            sb.append("main").append(File.separator);
            if (isInSpringBoot) {
                sb.append("resources").append(File.separator);
            } else {
                sb.append("webapp").append(File.separator);
            }
            sb.append("static").append(File.separator);
            sb.append("api.html");
            apiHtmlPath = sb.toString();
        }
        this.makeDirs(apiHtmlPath.substring(0, apiHtmlPath.lastIndexOf(File.separator)));
        this.logger.info("apiHtmlPath:{}", (Object)apiHtmlPath);
        HashMap<String, Object> datas = new HashMap<String, Object>();
        datas.put("controllerInfoList", controllerInfoList);
        datas.put("controllerInfoJson", JSON.toJSONString(controllerInfoList));
        String modelStr = FtlUtil.build(this.getClass(), "/META-INF/ftl/", datas, apiHtml);
        HtmlCompressor compressor = new HtmlCompressor();
        compressor.setCompressCss(true);
        compressor.setEnabled(true);
        compressor.setCompressCss(true);
        compressor.setYuiJsPreserveAllSemiColons(true);
        compressor.setYuiJsLineBreak(1);
        compressor.setPreserveLineBreaks(false);
        compressor.setRemoveIntertagSpaces(true);
        compressor.setRemoveComments(true);
        compressor.setRemoveMultiSpaces(true);
        modelStr = compressor.compress(modelStr);
        boolean modelRes = this.writeFile(modelStr, apiHtmlPath, true);
        this.logger.info("createApiHtml:{} res:{}", (Object)apiHtmlPath, (Object)modelRes);
    }

    private boolean checkIsInSpringBoot() {
        String className = "com.jsm.spring.boot.autoconfigure.SpringBootVFS";
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private void makeDirs(String dirPath) {
        File file = new File(dirPath);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    private String getClazzUri(Class clazz) {
        RequestMapping baseRequestMapping = clazz.getAnnotation(RequestMapping.class);
        if (baseRequestMapping != null && baseRequestMapping.value().length > 0) {
            return baseRequestMapping.value()[0];
        }
        PostMapping postMapping = clazz.getAnnotation(PostMapping.class);
        if (postMapping != null && postMapping.value().length > 0) {
            return postMapping.value()[0];
        }
        PutMapping putMapping = clazz.getAnnotation(PutMapping.class);
        if (putMapping != null && putMapping.value().length > 0) {
            return putMapping.value()[0];
        }
        GetMapping getMapping = clazz.getAnnotation(GetMapping.class);
        if (getMapping != null && getMapping.value().length > 0) {
            return getMapping.value()[0];
        }
        DeleteMapping deleteMapping = clazz.getAnnotation(DeleteMapping.class);
        if (deleteMapping != null && deleteMapping.value().length > 0) {
            return deleteMapping.value()[0];
        }
        return "";
    }

    private String getMethodUri(Method method) {
        RequestMapping baseRequestMapping = method.getAnnotation(RequestMapping.class);
        if (baseRequestMapping != null && baseRequestMapping.value().length > 0) {
            return baseRequestMapping.value()[0];
        }
        PostMapping postMapping = method.getAnnotation(PostMapping.class);
        if (postMapping != null && postMapping.value().length > 0) {
            return postMapping.value()[0];
        }
        PutMapping putMapping = method.getAnnotation(PutMapping.class);
        if (putMapping != null && putMapping.value().length > 0) {
            return putMapping.value()[0];
        }
        GetMapping getMapping = method.getAnnotation(GetMapping.class);
        if (getMapping != null && getMapping.value().length > 0) {
            return getMapping.value()[0];
        }
        DeleteMapping deleteMapping = method.getAnnotation(DeleteMapping.class);
        if (deleteMapping != null && deleteMapping.value().length > 0) {
            return deleteMapping.value()[0];
        }
        return "";
    }

    private String getHttpMethodName(Method method) {
        RequestMapping baseRequestMapping = method.getAnnotation(RequestMapping.class);
        if (baseRequestMapping != null) {
            return baseRequestMapping.method()[0].name().toLowerCase();
        }
        PostMapping postMapping = method.getAnnotation(PostMapping.class);
        if (postMapping != null) {
            return "post";
        }
        PutMapping putMapping = method.getAnnotation(PutMapping.class);
        if (putMapping != null) {
            return "put";
        }
        GetMapping getMapping = method.getAnnotation(GetMapping.class);
        if (getMapping != null) {
            return "get";
        }
        DeleteMapping deleteMapping = method.getAnnotation(DeleteMapping.class);
        if (deleteMapping != null) {
            return "delete";
        }
        return "";
    }

    private List<ApiInfo> getApiInfoList(Class clazz) {
        String basePath = "";
        RestController restController = clazz.getAnnotation(RestController.class);
        if (restController == null) {
            return null;
        }
        basePath = basePath + this.getClazzUri(clazz);
        ArrayList<ApiInfo> apiInfoList = new ArrayList<ApiInfo>();
        Method[] methods = clazz.getMethods();
        Arrays.sort(methods, new Comparator<Method>(){

            @Override
            public int compare(Method o1, Method o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (Method method : methods) {
            RequestMapping requestMapping = method.getAnnotation(RequestMapping.class);
            if (requestMapping == null || requestMapping.method().length == 0 || requestMapping.value().length == 0) continue;
            ApiInfo apiInfo = new ApiInfo();
            apiInfo.name = method.getName();
            apiInfo.comments = "";
            apiInfo.httpMethod = this.getHttpMethodName(method);
            apiInfo.url = basePath + this.getMethodUri(method);
            this.logger.info("getApiInfoList clazz:{}, methodName:{},url:{}", new Object[]{clazz.getSimpleName(), apiInfo.name, apiInfo.url});
            ApiOperation apiOperation = method.getAnnotation(ApiOperation.class);
            if (apiOperation != null) {
                apiInfo.comments = apiOperation.value() + " notes:" + apiOperation.notes();
            }
            block1: for (Parameter parameter : method.getParameters()) {
                PathVariable pathVariable = parameter.getAnnotation(PathVariable.class);
                if (pathVariable != null) {
                    apiInfo.pathVarList = this.getSingleReqParamFields(parameter, pathVariable.value());
                    continue;
                }
                RequestParam requestParam = parameter.getAnnotation(RequestParam.class);
                if (requestParam != null) {
                    apiInfo.reqParamList = this.getSingleReqParamFields(parameter, requestParam.value());
                    continue;
                }
                RequestBody requestBody = parameter.getAnnotation(RequestBody.class);
                if (requestBody != null) {
                    apiInfo.bodyParamList = JsmFrameUtil.getFieldInfoList(parameter.getType(), null, null, 0, false);
                    continue;
                }
                if (!ValidateModel.class.isAssignableFrom(parameter.getType())) continue;
                apiInfo.reqParamList = JsmFrameUtil.getFieldInfoList(parameter.getType(), JsmFrameUtil.getGenericNames(parameter.getParameterizedType()), null, 0, false);
                if (!Page.class.isAssignableFrom(parameter.getType())) continue;
                for (FieldInfo fieldInfo : apiInfo.reqParamList) {
                    if (!fieldInfo.fieldName.equals("list")) continue;
                    apiInfo.reqParamList.remove(fieldInfo);
                    continue block1;
                }
            }
            if (!method.getReturnType().getName().equals("void")) {
                apiInfo.respParamList = JsmFrameUtil.getFieldInfoList(method.getReturnType(), JsmFrameUtil.getGenericNames(method.getGenericReturnType()), null, 0, false);
            }
            apiInfoList.add(apiInfo);
        }
        return apiInfoList;
    }

    private List<FieldInfo> getSingleReqParamFields(Parameter parameter, String fieldName) {
        ArrayList<FieldInfo> reqParamList = new ArrayList<FieldInfo>();
        FieldInfo fieldInfo = new FieldInfo();
        fieldInfo.fieldName = parameter.getName();
        fieldInfo.fieldType = parameter.getType().getSimpleName();
        fieldInfo.required = false;
        FieldAnn fieldAnn = parameter.getAnnotation(FieldAnn.class);
        if (fieldAnn != null) {
            if (!StringUtil.isEmpty(fieldAnn.name())) {
                fieldInfo.fieldName = fieldAnn.name();
            }
            if (fieldAnn.maxLen() != -1) {
                fieldInfo.maxLength = fieldAnn.maxLen();
            }
            fieldInfo.required = fieldAnn.required();
            fieldInfo.comments = fieldAnn.comments();
        }
        if (!StringUtil.isEmpty(fieldName)) {
            fieldInfo.fieldName = fieldName;
        }
        reqParamList.add(fieldInfo);
        return reqParamList;
    }

    public void genFrontJsApi() {
        String restPackageName = AppContext.get("gen.rest.package.name");
        Set<Class<?>> classSet = ClassUtil.loadClass(restPackageName, false);
        ArrayList<ControllerInfo> controllerInfoList = new ArrayList<ControllerInfo>();
        for (Class<?> clazz : classSet) {
            String name;
            ControllerInfo controllerInfo = new ControllerInfo();
            controllerInfo.name = name = clazz.getSimpleName();
            controllerInfo.apiInfos = this.getApiInfoList(clazz);
            controllerInfoList.add(controllerInfo);
        }
        for (ControllerInfo controllerInfo : controllerInfoList) {
            this.genFrontJsApi(controllerInfo, true);
        }
    }

    public void genFrontJsApi(Class clazz, boolean override) {
        String name;
        ControllerInfo controllerInfo = new ControllerInfo();
        controllerInfo.name = name = clazz.getSimpleName();
        controllerInfo.apiInfos = this.getApiInfoList(clazz);
        this.genFrontJsApi(controllerInfo, true);
    }

    private void genFrontJsApi(ControllerInfo controllerInfo, boolean override) {
        String frontApiDir = AppContext.get("gen.front.api.dir");
        String frontApi = "frontApi.ftl";
        String apiFileName = controllerInfo.name;
        String apiFilePath = frontApiDir + File.separator + apiFileName + ".js";
        HashMap<String, List<ApiInfo>> datas = new HashMap<String, List<ApiInfo>>();
        datas.put("methodInfoList", controllerInfo.apiInfos);
        String modelStr = FtlUtil.build(this.getClass(), "/META-INF/ftl/", datas, frontApi);
        boolean modelRes = this.writeFile(modelStr, apiFilePath, override);
        this.logger.info("createModel:{} res:{}", (Object)apiFilePath, (Object)modelRes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeFile(String text, String filePath, boolean override) {
        File modelFile = new File(filePath);
        if (!override && modelFile.exists()) {
            this.logger.warn("file:{} exists, ignore! override:{}", (Object)filePath, (Object)override);
            return false;
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(filePath);
            fos.write(text.getBytes());
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                this.logger.error("", (Throwable)e);
            }
        }
    }

    private List<FieldInfo> getTableFieldInfo(String tableName, Map<String, Object> datas) {
        this.logger.info("getTableFieldInfo:{}", (Object)tableName);
        ArrayList<FieldInfo> list = new ArrayList<FieldInfo>();
        List<CreateTableInfo> res = this.dbMapper.showCreateTable(tableName);
        if (res.size() > 0) {
            String createInfo = res.get((int)0).CreateTable;
            this.logger.info(createInfo);
            createInfo = createInfo.substring(createInfo.indexOf("(") + 2, createInfo.lastIndexOf(")") - 1);
            this.logger.info(createInfo);
            String[] lineArr = createInfo.split("\\n");
            for (int i = 1; i < lineArr.length; ++i) {
                String[] arr = lineArr[i].trim().replaceAll("\\s+", " ").replace("NOT NULL", "NOT_NULL").split(" ");
                if (!arr[0].startsWith("`")) {
                    this.logger.warn("ignore line:{}", (Object)lineArr[i]);
                    continue;
                }
                FieldInfo info = new FieldInfo();
                info.fieldName = arr[0].replace("`", "");
                if (info.fieldName.equals("`id`")) {
                    this.logger.warn("id line ignore:{}", (Object)lineArr[i]);
                    continue;
                }
                info.fieldType = this.mysqlTypeToJavaType(arr[1]);
                if (info.fieldType == null) {
                    this.logger.warn("fieldType not found , ignore line:{}", (Object)lineArr[i]);
                    continue;
                }
                if (lineArr[i].contains(" DEFAULT ") && arr.length >= 4) {
                    info.defaultVal = arr[3];
                }
                if (lineArr[i].contains(" COMMENT ")) {
                    info.comments = lineArr[i].substring(lineArr[i].indexOf("'") + 1);
                    info.comments = info.comments.substring(0, info.comments.length() - 2);
                }
                if (lineArr[i].contains("NOT NULL")) {
                    info.required = true;
                }
                if (arr[1].startsWith("varchar(")) {
                    info.maxLength = StringUtil.extractInteger(arr[1]);
                }
                if (info.fieldType.equals("Date")) {
                    datas.put("hasDate", true);
                }
                list.add(info);
            }
        }
        return list;
    }

    private String mysqlTypeToJavaType(String mysqlType) {
        if (mysqlType.startsWith("bigint")) {
            return "Long";
        }
        if (mysqlType.startsWith("tinyint")) {
            return "Byte";
        }
        if (mysqlType.startsWith("smallint")) {
            return "Short";
        }
        if (mysqlType.startsWith("int") || mysqlType.startsWith("integer")) {
            return "Integer";
        }
        if (mysqlType.startsWith("varchar") || mysqlType.contains("text")) {
            return "String";
        }
        if (mysqlType.startsWith("bit")) {
            return "Boolean";
        }
        if (mysqlType.startsWith("float")) {
            return "Float";
        }
        if (mysqlType.startsWith("double")) {
            return "Double";
        }
        if (mysqlType.startsWith("date") || mysqlType.startsWith("timestamp")) {
            return "Date";
        }
        return null;
    }

    private String tableNameToModelName(String tableName) {
        String clazzName = tableName;
        if (clazzName.endsWith("_t")) {
            clazzName = clazzName.substring(0, clazzName.length() - 2);
        }
        StringBuilder sb = new StringBuilder();
        boolean toUpper = true;
        for (int i = 0; i < clazzName.length(); ++i) {
            char c = clazzName.charAt(i);
            if (c == '_') {
                toUpper = true;
                continue;
            }
            sb.append(toUpper ? Character.toUpperCase(c) : c);
            if (!toUpper) continue;
            toUpper = false;
        }
        return sb.toString();
    }
}

