/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.service;

import com.jsmframe.annotation.OrderAnn;
import com.jsmframe.consts.BasePairConsts;
import com.jsmframe.jedis.JedisService;
import com.jsmframe.jedis.ShardedJedisCmd;
import com.jsmframe.order.BaseOrderLine;
import com.jsmframe.pair.Pair;
import com.jsmframe.utils.TemplateUtil;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Resource;
import redis.clients.jedis.ShardedJedis;

public class FairLineService
extends BaseOrderLine {
    @Resource
    private JedisService jedisService;
    private AtomicLong seed = new AtomicLong();

    @Override
    public Pair<String> order(final String key, OrderAnn orderAnn) {
        if (this.getStatus().equals(BasePairConsts.ACTIVITY_NOT_STARTED) || this.getStatus().equals(BasePairConsts.ACTIVITY_OVER)) {
            return this.getStatus();
        }
        final String member = TemplateUtil.formatWithContextVar(orderAnn.userKey());
        Long idx = this.jedisService.exec(new ShardedJedisCmd<Long>(){

            @Override
            public Long run(ShardedJedis shardedJedis) throws Exception {
                Long idx = shardedJedis.zrank(key, member);
                if (idx == null) {
                    shardedJedis.zadd(key, (double)FairLineService.this.seed.incrementAndGet(), member);
                } else {
                    shardedJedis.zincrby(key, -1.0, member);
                }
                return shardedJedis.zrank(key, member);
            }
        });
        if (idx == 0L) {
            return BasePairConsts.ACTIVITY_TURN;
        }
        return BasePairConsts.ACTIVITY_QUEUEING;
    }
}

