/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.service;

import com.jsmframe.base.BaseService;
import com.jsmframe.context.AppContext;
import com.jsmframe.dao.model.Page;
import com.jsmframe.disruptor.JsmDisruptor;
import com.jsmframe.elastic.ElasticClient;
import com.jsmframe.service.ApiStatService;
import com.jsmframe.stat.model.Alarm;
import com.jsmframe.stat.model.ApiStat;
import com.jsmframe.utils.DateUtil;
import com.jsmframe.utils.StringUtil;
import com.jsmframe.utils.SystemUtil;
import com.lmax.disruptor.EventHandler;
import org.springframework.stereotype.Service;

@Service
public class DefaultApiStatService
extends BaseService
implements ApiStatService {
    private ElasticClient elasticClient;
    private int apiAlarmTime = AppContext.getAsInteger("alarm.api.time", 30000);
    private String jsonOption = "{\"mappings\":{\"properties\":{\"beginTime\":{\"type\":\"date\",\"format\":\"yyyyMMdd HH:mm:ss.SSS||epoch_millis\"},\"endTime\":{\"type\":\"date\",\"format\":\"yyyyMMdd HH:mm:ss.SSS||epoch_millis\"},\"createTime\":{\"type\":\"date\",\"format\":\"yyyyMMdd HH:mm:ss.SSS||epoch_millis\"},\"spendTime\":{\"type\":\"integer\"},\"url\":{\"type\":\"keyword\"},\"reqId\":{\"type\":\"keyword\"},\"name\":{\"type\":\"keyword\"},\"httpStatus\":{\"type\":\"integer\"},\"respCode\":{\"type\":\"keyword\"}}}}";
    private JsmDisruptor<String> stringDisruptor = new JsmDisruptor<String>(new EventHandler<JsmDisruptor.MessageEvent<String>>(){

        public void onEvent(JsmDisruptor.MessageEvent<String> stringMessageEvent, long l, boolean b) throws Exception {
            if (DefaultApiStatService.this.elasticClient != null) {
                DefaultApiStatService.this.elasticClient.post((String)stringMessageEvent.message);
            } else {
                SystemUtil.addAlarm(new Alarm("DefaultApiStatService", "elasticClient is null."));
            }
        }
    });

    public DefaultApiStatService() {
        String address = AppContext.get("elastic.address");
        if (!StringUtil.isEmpty(address)) {
            String clusterId = AppContext.get("cluster.id");
            this.elasticClient = new ElasticClient(String.format("%s/stat_%s", address, clusterId));
            boolean res = this.elasticClient.createIndexIfNotExists(this.jsonOption);
            if (!res) {
                this.logger.error("create elasticClient error:{}", (Object)res);
            }
        }
    }

    @Override
    public void add(String name, String url, String reqId, long startTime, long endTime, Integer httpStatus, String respCode) {
        long spendTime = endTime - startTime;
        ApiStat apiStat = new ApiStat();
        apiStat.name = name;
        apiStat.reqId = reqId;
        apiStat.url = url;
        apiStat.beginTime = startTime;
        apiStat.endTime = endTime;
        apiStat.spendTime = spendTime;
        apiStat.httpStatus = httpStatus;
        apiStat.respCode = respCode;
        apiStat.createTime = DateUtil.currentTime();
        this.add(apiStat);
    }

    @Override
    public Long add(ApiStat apiStat) {
        if (apiStat.spendTime > (long)this.apiAlarmTime) {
            SystemUtil.addAlarm(new Alarm("apiAlarmTime", StringUtil.toJson(apiStat)));
        }
        this.stringDisruptor.pushMessage(StringUtil.toJson(apiStat));
        return null;
    }

    @Override
    public void pageList(Page<ApiStat> page) {
    }

    public void recreateIdx() {
        this.elasticClient.recreateIndex(this.jsonOption);
    }
}

