/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.service;

import com.alibaba.fastjson.TypeReference;
import com.jsmframe.base.BaseService;
import com.jsmframe.context.AppContext;
import com.jsmframe.context.SpringContext;
import com.jsmframe.jedis.JedisService;
import com.jsmframe.utils.StringUtil;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.annotation.Resource;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.springframework.stereotype.Service;

@Service
public class CacheService
extends BaseService {
    private ExecutorService executorService = null;
    private Cache queryCache;
    @Resource
    private JedisService jedisService;

    private void init() {
        Integer threadNumber = AppContext.getAsInteger("cache.service.async.thread");
        if (threadNumber == null) {
            threadNumber = 1;
        }
        this.logger.info("CacheService Redis use async thread number:{}", (Object)threadNumber);
        this.executorService = Executors.newFixedThreadPool(threadNumber, new ThreadFactory(){
            byte index = 0;

            @Override
            public Thread newThread(Runnable runnable) {
                this.index = (byte)(this.index + 1);
                return new Thread(runnable, "cache-pool" + this.index);
            }
        });
    }

    public Cache getQueryCache() {
        if (this.queryCache == null) {
            String ehcacheName = AppContext.get("cache.service.cache.name");
            if (StringUtil.isEmpty(ehcacheName)) {
                ehcacheName = "queryCache";
            }
            this.queryCache = (Cache)SpringContext.getBean(ehcacheName);
            this.logger.info("CacheService EhCache use cache name:{}", (Object)ehcacheName);
        }
        return this.queryCache;
    }

    public void close() {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }

    private boolean check() {
        try {
            if (this.executorService == null) {
                this.init();
            }
            return true;
        }
        catch (Exception e) {
            this.logger.error("CacheService init error.", (Throwable)e);
            return false;
        }
    }

    public void remove(String key) {
        this.queryCache.remove((Serializable)((Object)key));
        this.jedisService.del(key);
    }

    public <T> T get(String key, Class<T> clazz) {
        if (!this.check()) {
            return null;
        }
        T result = this.getFromL1(key);
        if (result == null) {
            result = this.getFromL2(key, clazz);
        }
        return result;
    }

    public <T> T get(String key, TypeReference<T> typeReference) {
        if (!this.check()) {
            return null;
        }
        T result = this.getFromL1(key);
        if (result == null) {
            result = this.getFromL2(key, typeReference);
        }
        return result;
    }

    public <T> T get(String key, Type type) {
        if (!this.check()) {
            return null;
        }
        T result = this.getFromL1(key);
        if (result == null) {
            result = this.getFromL2(key, type);
        }
        return result;
    }

    public void set(final String key, final int seconds, final Serializable object) {
        if (!this.check()) {
            return;
        }
        Cache ehQueryCache = this.getQueryCache();
        ehQueryCache.put(new Element((Serializable)((Object)key), object));
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                CacheService.this.jedisService.setex(key, seconds, StringUtil.toJson(object));
            }
        });
    }

    private <T> T getFromL1(String key) {
        if (!this.check()) {
            return null;
        }
        Cache ehQueryCache = this.getQueryCache();
        Element element = ehQueryCache.get((Serializable)((Object)key));
        if (element != null) {
            this.logger.debug("from cache l1 key:{}", (Object)key);
            return (T)element.getObjectValue();
        }
        return null;
    }

    private <T> T getFromL2(String key, Class<T> clazz) {
        T result;
        if (!this.check()) {
            return null;
        }
        Cache ehQueryCache = this.getQueryCache();
        String resultStr = this.jedisService.get(key);
        if (!StringUtil.isEmpty(resultStr) && (result = StringUtil.parseObject(resultStr, clazz)) != null) {
            this.logger.debug("from cache l2 key:{}", (Object)key);
            ehQueryCache.put(new Element((Serializable)((Object)key), (Serializable)result));
            return result;
        }
        return null;
    }

    private <T> T getFromL2(String key, TypeReference<T> typeReference) {
        T result;
        if (!this.check()) {
            return null;
        }
        Cache ehQueryCache = this.getQueryCache();
        String resultStr = this.jedisService.get(key);
        if (!StringUtil.isEmpty(resultStr) && (result = StringUtil.parseObject(resultStr, typeReference)) != null) {
            this.logger.debug("from cache l2 key:{}", (Object)key);
            ehQueryCache.put(new Element((Serializable)((Object)key), (Serializable)result));
            return result;
        }
        return null;
    }

    private <T> T getFromL2(String key, Type type) {
        Object result;
        if (!this.check()) {
            return null;
        }
        Cache ehQueryCache = this.getQueryCache();
        String resultStr = this.jedisService.get(key);
        if (!StringUtil.isEmpty(resultStr) && (result = StringUtil.parseObject(resultStr, type)) != null) {
            this.logger.debug("from cache l2 key:{}", (Object)key);
            ehQueryCache.put(new Element((Serializable)((Object)key), (Serializable)result));
            return result;
        }
        return null;
    }
}

