/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.mybatis;

import com.jsmframe.mybatis.AbstractDialect;
import java.util.regex.Matcher;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.SqlSource;

public class SqlServer2012Dialect
extends AbstractDialect {
    @Override
    public String concatCountSql(String sql) {
        StringBuffer sb = new StringBuffer("select count(*) from ");
        int beginIndex = this.findBeginIdx(sql);
        Matcher orderByMatcher = orderByPattern.matcher(sql);
        int lastIndex = sql.lastIndexOf(")");
        if (lastIndex != -1 && orderByMatcher.find(lastIndex)) {
            sb.append(sql.substring(beginIndex, orderByMatcher.start()));
        } else {
            sb.append(sql.substring(beginIndex));
        }
        return sb.toString();
    }

    @Override
    public String concatPageSql(String sql, int startRow, int pageSize) {
        StringBuilder sqlBuilder = new StringBuilder(sql.length() + 64);
        sqlBuilder.append(sql);
        sqlBuilder.append(" OFFSET ");
        sqlBuilder.append(startRow);
        sqlBuilder.append(" ROWS FETCH NEXT ");
        sqlBuilder.append(pageSize);
        sqlBuilder.append(" ROWS ONLY");
        return sqlBuilder.toString();
    }

    @Override
    public SqlSource getSqlSource(BoundSql boundSql) {
        return new MySqlSource(boundSql);
    }

    public class MySqlSource
    implements SqlSource {
        BoundSql boundSql;

        public MySqlSource(BoundSql boundSql) {
            this.boundSql = boundSql;
        }

        public BoundSql getBoundSql(Object parameterObject) {
            return this.boundSql;
        }
    }
}

