/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.mybatis;

import com.jsmframe.mybatis.AbstractDialect;
import java.util.regex.Matcher;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.SqlSource;

public class Db2Dialect
extends AbstractDialect {
    @Override
    public String concatCountSql(String sql) {
        StringBuffer sb = new StringBuffer("select count(*) from ");
        int beginIndex = this.findBeginIdx(sql);
        Matcher orderByMatcher = orderByPattern.matcher(sql);
        int lastIndex = sql.lastIndexOf(")");
        if (lastIndex != -1 && orderByMatcher.find(lastIndex)) {
            sb.append(sql.substring(beginIndex, orderByMatcher.start()));
        } else {
            sb.append(sql.substring(beginIndex));
        }
        return sb.toString();
    }

    @Override
    public String concatPageSql(String sql, int startRow, int pageSize) {
        StringBuilder sb = new StringBuilder(sql.length() + 140);
        sb.append("SELECT * FROM (SELECT TMP_PAGE.*,ROWNUMBER() OVER() AS ROW_ID FROM ( ");
        sb.append(sql);
        sb.append(" ) AS TMP_PAGE) TMP_PAGE WHERE ROW_ID BETWEEN ");
        sb.append(startRow);
        sb.append(" AND ");
        sb.append(startRow + pageSize);
        return sb.toString();
    }

    @Override
    public SqlSource getSqlSource(BoundSql boundSql) {
        return new MySqlSource(boundSql);
    }

    public class MySqlSource
    implements SqlSource {
        BoundSql boundSql;

        public MySqlSource(BoundSql boundSql) {
            this.boundSql = boundSql;
        }

        public BoundSql getBoundSql(Object parameterObject) {
            return this.boundSql;
        }
    }
}

