/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.log4j2;

import com.alibaba.fastjson.JSONObject;
import com.jsmframe.context.AppContext;
import com.jsmframe.context.WebContext;
import com.jsmframe.disruptor.JsmDisruptor;
import com.jsmframe.elastic.ElasticClient;
import com.jsmframe.stat.model.Alarm;
import com.jsmframe.utils.DateUtil;
import com.jsmframe.utils.StringUtil;
import com.jsmframe.utils.SystemUtil;
import com.lmax.disruptor.EventHandler;
import java.io.Serializable;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.impl.ThrowableProxy;
import org.apache.logging.log4j.core.layout.PatternLayout;

@Plugin(name="ElasticAppender", category="Core", elementType="appender", printObject=true)
public class ElasticAppender
extends AbstractAppender {
    private static ElasticClient elasticClient;
    private static String address;
    private static AtomicLong idAi;
    private static String clusterId;
    private static String jsonOption;
    private boolean hasAddress = true;
    private JsmDisruptor<String> stringDisruptor = new JsmDisruptor<String>(new EventHandler<JsmDisruptor.MessageEvent<String>>(){

        public void onEvent(JsmDisruptor.MessageEvent<String> stringMessageEvent, long sequence, boolean endOfBatch) throws Exception {
            try {
                elasticClient.post(ElasticAppender.this.getId(), (String)stringMessageEvent.message);
            }
            catch (Exception e) {
                LOGGER.error("ElasticAppender onEvent error:", (Throwable)e);
                SystemUtil.addAlarm(new Alarm("ElasticAppender", "onEvent error."));
            }
        }
    }, 1024);

    protected ElasticAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions) {
        super(name, filter, layout, ignoreExceptions);
    }

    public void append(LogEvent event) {
        if (!this.hasAddress) {
            return;
        }
        String reqId = WebContext.getRequestId(event.getThreadName());
        if (reqId == null) {
            return;
        }
        if (elasticClient == null) {
            boolean ok = this.tryCreateElasticClient();
            if (ok) {
                LOGGER.info("ElasticAppender create elasticClient ok:" + address);
            } else {
                return;
            }
        }
        JSONObject jsonObject = new JSONObject();
        ThrowableProxy thrownProxy = event.getThrownProxy();
        jsonObject.put("time", (Object)event.getTimeMillis());
        jsonObject.put("logName", (Object)event.getLoggerName());
        if (event.getSource() != null) {
            jsonObject.put("methodName", (Object)event.getSource().getMethodName());
        }
        if (event.getMessage() != null) {
            jsonObject.put("logMsg", (Object)event.getMessage().getFormattedMessage());
        }
        jsonObject.put("reqId", (Object)reqId);
        jsonObject.put("level", (Object)event.getLevel().name());
        jsonObject.put("thread", (Object)event.getThreadName());
        if (thrownProxy != null) {
            jsonObject.put("exMsg", (Object)thrownProxy.getMessage());
            jsonObject.put("exName", (Object)thrownProxy.getName());
            jsonObject.put("exTrace", (Object)this.parseException(thrownProxy.getStackTrace()));
        }
        this.stringDisruptor.pushMessage(jsonObject.toJSONString());
    }

    private String getId() {
        try {
            long intCount = 0L;
            intCount = idAi.getAndIncrement();
            if (intCount + 1000L > Long.MAX_VALUE) {
                idAi.set(0L);
            }
            return String.format("%s-%s-%s", clusterId, DateUtil.format(DateUtil.currentDate(), "yyyyMMdd"), intCount);
        }
        catch (Exception e) {
            LOGGER.error("getId error.", (Throwable)e);
            return StringUtil.uuid();
        }
    }

    private boolean tryCreateElasticClient() {
        if (StringUtil.isEmpty(address)) {
            LOGGER.debug("ElasticAppender no address attribute. find elastic.address in AppContext");
            address = AppContext.get("elastic.address");
            if (StringUtil.isEmpty(address)) {
                LOGGER.error("tryCreateElasticClient give up, address is empty.");
                if (this.hasAddress) {
                    this.hasAddress = false;
                }
                return false;
            }
        }
        LOGGER.info("elastic.address:" + address);
        clusterId = AppContext.get("cluster.id");
        elasticClient = new ElasticClient(String.format("%s/app_%s", address, clusterId));
        elasticClient.createIndexIfNotExists(jsonOption);
        return true;
    }

    private String parseException(StackTraceElement[] stackTrace) {
        StringBuffer sb = new StringBuffer();
        sb.append("\n");
        Arrays.stream(stackTrace).forEach(e -> sb.append(e.getClassName()).append(".").append(e.getMethodName()).append("(").append(e.getFileName()).append(":").append(e.getLineNumber()).append(")").append("\n"));
        return sb.toString();
    }

    @PluginFactory
    public static ElasticAppender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="Filter") Filter filter, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginAttribute(value="ignoreExceptions") boolean ignoreExceptions, @PluginAttribute(value="address") String address) {
        if (name == null) {
            name = "elastic";
            LOGGER.warn("ElasticAppender no name attribute,use default:" + name);
        }
        if (layout == null) {
            layout = PatternLayout.createDefaultLayout();
        }
        return new ElasticAppender(name, filter, (Layout<? extends Serializable>)layout, ignoreExceptions);
    }

    public static void recreateDb() {
        if (elasticClient != null) {
            elasticClient.recreateIndex(jsonOption);
        }
    }

    static {
        idAi = new AtomicLong(0L);
        jsonOption = "{\"mappings\":{\"properties\":{\"time\":{\"type\":\"date\",\"format\":\"yyyyMMdd HH:mm:ss.SSS||epoch_millis\"},\"logName\":{\"type\":\"keyword\"},\"methodName\":{\"type\":\"keyword\"},\"reqId\":{\"type\":\"keyword\"},\"level\":{\"type\":\"keyword\"},\"thread\":{\"type\":\"keyword\"}}}}";
    }
}

