/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.interceptor;

import com.jsmframe.context.AppContext;
import com.jsmframe.context.SpringContext;
import com.jsmframe.context.WebContext;
import com.jsmframe.rest.resp.RestResp;
import com.jsmframe.service.DefaultApiStatService;
import com.jsmframe.stat.model.ApiStat;
import com.jsmframe.utils.DateUtil;
import com.jsmframe.utils.JsmFrameUtil;
import com.jsmframe.utils.LogUtil;
import com.jsmframe.utils.ResponseUtil;
import com.jsmframe.utils.StringUtil;
import com.jsmframe.utils.ThreadLocalUtil;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.filter.OncePerRequestFilter;

public class JsmFilter
extends OncePerRequestFilter {
    private Logger logger = LogUtil.log(((Object)((Object)this)).getClass());
    private String encoding = "UTF-8";
    private boolean apiStat = AppContext.getAsBoolean("api.stat", false);
    private String[] excludeArr = null;

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    protected void initFilterBean() throws ServletException {
        super.initFilterBean();
        String exclude = this.getFilterConfig().getInitParameter("exclude");
        if (!StringUtil.isEmpty(exclude)) {
            this.excludeArr = exclude.split(";");
        }
    }

    private boolean isExclude(HttpServletRequest request) {
        if (this.excludeArr != null) {
            String servletPath = request.getServletPath();
            for (String pattern : this.excludeArr) {
                if (!servletPath.startsWith(pattern)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain fc) {
        if (this.isExclude(request)) {
            try {
                fc.doFilter((ServletRequest)request, (ServletResponse)response);
            }
            catch (Exception e) {
                this.logger.error("", (Throwable)e);
            }
            return;
        }
        ThreadLocalUtil.cleanAll();
        WebContext.setRequest(request);
        WebContext.setResponse(response);
        String reqMethod = request.getMethod();
        long pid = Thread.currentThread().getId();
        String uri = String.format("%s;%s;%s", pid, reqMethod, request.getRequestURI(), WebContext.getRemoteIp(request));
        String reqId = WebContext.getRequestId();
        this.logger.info(uri);
        long startTime = System.currentTimeMillis();
        response.setCharacterEncoding(this.encoding);
        try {
            if (reqMethod.equals(RequestMethod.OPTIONS.name())) {
                String error = "request method not support.";
                this.logger.warn("request method not support {}", (Object)reqMethod);
                throw new RuntimeException(error);
            }
            this.logger.debug("before fc.doFilter");
            fc.doFilter((ServletRequest)request, (ServletResponse)response);
            this.logger.debug("after fc.doFilter");
        }
        catch (Exception e) {
            String error = "request error url:" + request.getRequestURL().toString();
            this.logger.error(error, (Throwable)e);
            RestResp errorResp = JsmFrameUtil.dealException(e);
            ResponseUtil.outputRestResp(response, errorResp);
        }
        finally {
            if (this.apiStat) {
                this.statApi(request, response, reqMethod, startTime, reqId);
            }
            WebContext.removeRequest();
            WebContext.removeResponse();
            WebContext.clearRequestId();
            response.setHeader("Access-Control-Allow-Origin", "*");
            response.setHeader("Access-Control-Allow-Methods", "POST, GET, OPTIONS, DELETE, HEAD");
            response.setHeader("Access-Control-Max-Age", "3600");
            response.setHeader("Access-Control-Allow-Headers", "access-control-allow-origin, authority, content-type, version-info, X-Requested-With");
        }
    }

    private void statApi(HttpServletRequest request, HttpServletResponse response, String reqMethod, long startTime, String reqId) {
        DefaultApiStatService defaultApiStatService = SpringContext.getBean(DefaultApiStatService.class);
        long endTime = System.currentTimeMillis();
        long spendTime = endTime - startTime;
        ApiStat apiStat = new ApiStat();
        apiStat.name = AppContext.get("api.stat.name");
        apiStat.reqId = reqId;
        apiStat.url = reqMethod + " " + request.getRequestURI();
        apiStat.beginTime = startTime;
        apiStat.endTime = endTime;
        apiStat.spendTime = spendTime;
        apiStat.httpStatus = response.getStatus();
        apiStat.respCode = (String)request.getAttribute("jsm-resp-code");
        apiStat.createTime = DateUtil.currentTime();
        defaultApiStatService.add(apiStat);
    }
}

