/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.http;

import com.jsmframe.context.WebContext;
import com.jsmframe.http.HttpClientProcessor;
import com.jsmframe.http.MyConnectionSocketFactory;
import com.jsmframe.http.MySSLConnectionSocketFactory;
import com.jsmframe.stat.model.Alarm;
import com.jsmframe.utils.StringUtil;
import com.jsmframe.utils.SystemUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.status.StatusLogger;

public class HttpClient {
    private Logger logger = StatusLogger.getLogger();
    private Charset DEFAULT_CHARSET = Consts.UTF_8;
    private HttpHost proxyHost;
    private HttpClientContext httpClientContext = HttpClientContext.create();
    private PoolingHttpClientConnectionManager connManager;
    private RequestConfig requestConfig = RequestConfig.custom().setCookieSpec("standard").build();
    private CookieStore cookieStore = new BasicCookieStore();
    private boolean withExtra = true;
    private boolean useCookie = true;
    private HttpRequestRetryHandler myRetryHandler = new HttpRequestRetryHandler(){

        public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
            return false;
        }
    };

    public HttpClient() {
        if (this.useCookie) {
            this.httpClientContext.setCookieStore(this.cookieStore);
            this.httpClientContext.setRequestConfig(this.requestConfig);
        }
    }

    public HttpClient(boolean useCookie) {
        this.useCookie = useCookie;
        if (useCookie) {
            this.httpClientContext.setCookieStore(this.cookieStore);
            this.httpClientContext.setRequestConfig(this.requestConfig);
        }
    }

    private void addAlarm(String method, String url, String errorMessage) {
        SystemUtil.addAlarm(new Alarm("HttpClient", "" + method + "," + url + "," + errorMessage));
    }

    public boolean isWithExtra() {
        return this.withExtra;
    }

    public void setWithExtra(boolean withExtra) {
        this.withExtra = withExtra;
    }

    public void setSocksProxy(String ip, int port) {
        Registry reg = RegistryBuilder.create().register("http", (Object)new MyConnectionSocketFactory()).register("https", (Object)new MySSLConnectionSocketFactory(SSLContexts.createSystemDefault())).build();
        this.connManager = new PoolingHttpClientConnectionManager(reg);
        this.httpClientContext.setAttribute("socks.address", (Object)new InetSocketAddress(ip, port));
    }

    public HttpHost getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(HttpHost proxyHost) {
        this.proxyHost = proxyHost;
    }

    public String get(String url) {
        return this.get(null, url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(List<Header> headers, String url) {
        this.logger.debug("get url:" + url);
        String res = null;
        CloseableHttpClient httpclient = this.createClient();
        CloseableHttpResponse response = null;
        try {
            HttpGet httpGet = new HttpGet(url);
            if (headers != null) {
                httpGet.setHeaders(headers.toArray(new Header[headers.size()]));
            }
            this.setExtraHeaders((HttpRequestBase)httpGet);
            response = httpclient.execute((HttpUriRequest)httpGet, (HttpContext)this.httpClientContext);
            this.logger.debug("get url status:" + response.getStatusLine());
            res = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)this.DEFAULT_CHARSET);
            this.logger.debug("responseBody:{}", (Object)res);
            this.close(httpclient, response);
        }
        catch (Exception e) {
            try {
                this.logger.error("http get error:" + url, (Throwable)e);
                this.addAlarm("get", url, e.getMessage());
                this.close(httpclient, response);
            }
            catch (Throwable throwable) {
                this.close(httpclient, response);
                throw throwable;
            }
        }
        return res;
    }

    public void get(String url, HttpClientProcessor processor) {
        this.get(null, url, processor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(List<Header> headers, String url, HttpClientProcessor processor) {
        this.logger.debug("get url:" + url);
        CloseableHttpClient httpclient = this.createClient();
        CloseableHttpResponse response = null;
        try {
            HttpGet httpGet = new HttpGet(url);
            if (headers != null) {
                httpGet.setHeaders(headers.toArray(new Header[headers.size()]));
            }
            this.setExtraHeaders((HttpRequestBase)httpGet);
            processor.before((HttpRequestBase)httpGet);
            response = httpclient.execute((HttpUriRequest)httpGet, (HttpContext)this.httpClientContext);
            this.logger.debug("get url:" + response.getStatusLine());
            processor.complete((HttpResponse)response);
            this.close(httpclient, response);
            processor.after();
        }
        catch (Exception e) {
            try {
                this.logger.error("http get error:" + url, (Throwable)e);
                this.addAlarm("get", url, e.getMessage());
                processor.exception(e);
                this.close(httpclient, response);
                processor.after();
            }
            catch (Throwable throwable) {
                this.close(httpclient, response);
                processor.after();
                throw throwable;
            }
        }
    }

    public String post(String url, List<NameValuePair> nvps) {
        return this.post(null, url, nvps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String post(List<Header> headers, String url, List<NameValuePair> nvps) {
        this.logger.debug("post url:" + url);
        this.logger.debug("request nvps:{}", (Object)StringUtil.toJson(nvps));
        String res = null;
        CloseableHttpClient httpclient = this.createClient();
        CloseableHttpResponse response = null;
        try {
            HttpPost httpPost = new HttpPost(url);
            if (headers != null) {
                httpPost.setHeaders(headers.toArray(new Header[headers.size()]));
            }
            this.setExtraHeaders((HttpRequestBase)httpPost);
            UrlEncodedFormEntity httpEntity = new UrlEncodedFormEntity(nvps, this.DEFAULT_CHARSET);
            this.logger.debug(EntityUtils.toString((HttpEntity)httpEntity));
            httpPost.setEntity((HttpEntity)httpEntity);
            response = httpclient.execute((HttpUriRequest)httpPost, (HttpContext)this.httpClientContext);
            this.logger.debug(response.getStatusLine().toString());
            res = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)this.DEFAULT_CHARSET);
            this.logger.debug("responseBody:{}", (Object)res);
            this.close(httpclient, response);
        }
        catch (Exception e) {
            this.logger.error("http post error:" + url, (Throwable)e);
            this.addAlarm("post", url, e.getMessage());
        }
        finally {
            this.close(httpclient, response);
        }
        return res;
    }

    public void post(String url, List<NameValuePair> nvps, HttpClientProcessor processor) {
        this.post(null, url, nvps, processor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void post(List<Header> headers, String url, List<NameValuePair> nvps, HttpClientProcessor processor) {
        this.logger.debug("post url:" + url);
        this.logger.debug("request nvps:{}", (Object)StringUtil.toJson(nvps));
        CloseableHttpClient httpclient = this.createClient();
        CloseableHttpResponse response = null;
        try {
            HttpPost httpPost = new HttpPost(url);
            if (headers != null) {
                httpPost.setHeaders(headers.toArray(new Header[headers.size()]));
            }
            this.setExtraHeaders((HttpRequestBase)httpPost);
            UrlEncodedFormEntity httpEntity = new UrlEncodedFormEntity(nvps, this.DEFAULT_CHARSET);
            this.logger.debug(EntityUtils.toString((HttpEntity)httpEntity));
            httpPost.setEntity((HttpEntity)httpEntity);
            processor.before((HttpRequestBase)httpPost);
            response = httpclient.execute((HttpUriRequest)httpPost, (HttpContext)this.httpClientContext);
            this.logger.debug(response.getStatusLine().toString());
            processor.complete((HttpResponse)response);
            this.close(httpclient, response);
            processor.after();
        }
        catch (Exception e) {
            this.logger.error("http post error:" + url, (Throwable)e);
            this.addAlarm("post", url, e.getMessage());
            processor.exception(e);
        }
        finally {
            this.close(httpclient, response);
            processor.after();
        }
    }

    public String post(String url, Object data) {
        if (data instanceof String) {
            return this.post(null, url, (String)data);
        }
        return this.post(null, url, StringUtil.toJson(data));
    }

    public String post(String url, String strEntity) {
        return this.post(null, url, strEntity);
    }

    public String post(List<Header> headers, String url, Object data) {
        if (data instanceof String) {
            return this.post(headers, url, (String)data);
        }
        return this.post(headers, url, StringUtil.toJson(data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String post(List<Header> headers, String url, String strEntity) {
        this.logger.debug("post url:" + url);
        this.logger.debug("requestBody:{}", (Object)strEntity);
        String res = null;
        CloseableHttpClient httpclient = this.createClient();
        CloseableHttpResponse response = null;
        try {
            HttpPost httpPost = new HttpPost(url);
            StringEntity entity = new StringEntity(strEntity, this.DEFAULT_CHARSET);
            if (headers != null) {
                httpPost.setHeaders(headers.toArray(new Header[headers.size()]));
            } else {
                entity.setContentEncoding("UTF-8");
                entity.setContentType("application/json; charset=UTF-8");
            }
            this.setExtraHeaders((HttpRequestBase)httpPost);
            httpPost.setEntity((HttpEntity)entity);
            response = httpclient.execute((HttpUriRequest)httpPost, (HttpContext)this.httpClientContext);
            this.logger.debug(response.getStatusLine().toString());
            res = EntityUtils.toString((HttpEntity)response.getEntity());
            this.logger.debug("responseBody:{}", (Object)res);
            this.close(httpclient, response);
        }
        catch (Exception e) {
            this.logger.error("http post error:" + url, (Throwable)e);
            this.addAlarm("post", url, e.getMessage());
        }
        finally {
            this.close(httpclient, response);
        }
        return res;
    }

    public void post(String url, String strEntity, HttpClientProcessor processor) {
        this.post(null, url, strEntity, processor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void post(List<Header> headers, String url, String strEntity, HttpClientProcessor processor) {
        this.logger.debug("post url:" + url);
        this.logger.debug("requestBody:{}", (Object)strEntity);
        CloseableHttpClient httpclient = this.createClient();
        CloseableHttpResponse response = null;
        try {
            HttpPost httpPost = new HttpPost(url);
            StringEntity entity = new StringEntity(strEntity, this.DEFAULT_CHARSET);
            if (headers != null) {
                httpPost.setHeaders(headers.toArray(new Header[headers.size()]));
            } else {
                entity.setContentEncoding("UTF-8");
                entity.setContentType("application/json; charset=UTF-8");
            }
            this.setExtraHeaders((HttpRequestBase)httpPost);
            httpPost.setEntity((HttpEntity)entity);
            processor.before((HttpRequestBase)httpPost);
            response = httpclient.execute((HttpUriRequest)httpPost, (HttpContext)this.httpClientContext);
            this.logger.debug(response.getStatusLine().toString());
            processor.complete((HttpResponse)response);
            this.close(httpclient, response);
            processor.after();
        }
        catch (Exception e) {
            this.logger.error("http post error:" + url, (Throwable)e);
            this.addAlarm("post", url, e.getMessage());
            processor.exception(e);
        }
        finally {
            this.close(httpclient, response);
            processor.after();
        }
    }

    public String put(String url, Object data) {
        if (data instanceof String) {
            return this.put(null, url, (String)data);
        }
        return this.put(null, url, StringUtil.toJson(data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String put(List<Header> headers, String url, String strEntity) {
        this.logger.debug("put url:" + url);
        this.logger.debug("requestBody:{}", (Object)strEntity);
        String res = null;
        CloseableHttpClient httpclient = this.createClient();
        CloseableHttpResponse response = null;
        try {
            HttpPut httpPut = new HttpPut(url);
            StringEntity entity = new StringEntity(strEntity, this.DEFAULT_CHARSET);
            if (headers != null) {
                httpPut.setHeaders(headers.toArray(new Header[headers.size()]));
            } else {
                entity.setContentEncoding("UTF-8");
                entity.setContentType("application/json; charset=UTF-8");
            }
            this.setExtraHeaders((HttpRequestBase)httpPut);
            httpPut.setEntity((HttpEntity)entity);
            response = httpclient.execute((HttpUriRequest)httpPut, (HttpContext)this.httpClientContext);
            this.logger.debug(response.getStatusLine().toString());
            res = EntityUtils.toString((HttpEntity)response.getEntity());
            this.logger.debug("responseBody:{}", (Object)res);
            this.close(httpclient, response);
        }
        catch (Exception e) {
            this.logger.error("http put error:" + url, (Throwable)e);
            this.addAlarm("put", url, e.getMessage());
        }
        finally {
            this.close(httpclient, response);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(List<Header> headers, String url, String strEntity, HttpClientProcessor processor) {
        this.logger.debug("put url:" + url);
        this.logger.debug("requestBody:{}", (Object)strEntity);
        CloseableHttpClient httpclient = this.createClient();
        CloseableHttpResponse response = null;
        try {
            HttpPut httpPut = new HttpPut(url);
            StringEntity entity = new StringEntity(strEntity, this.DEFAULT_CHARSET);
            if (headers != null) {
                httpPut.setHeaders(headers.toArray(new Header[headers.size()]));
            } else {
                entity.setContentEncoding("UTF-8");
                entity.setContentType("application/json; charset=UTF-8");
            }
            this.setExtraHeaders((HttpRequestBase)httpPut);
            httpPut.setEntity((HttpEntity)entity);
            processor.before((HttpRequestBase)httpPut);
            response = httpclient.execute((HttpUriRequest)httpPut, (HttpContext)this.httpClientContext);
            this.logger.debug(response.getStatusLine().toString());
            processor.complete((HttpResponse)response);
            this.close(httpclient, response);
            processor.after();
        }
        catch (Exception e) {
            this.logger.error("http put error:" + url, (Throwable)e);
            this.addAlarm("put", url, e.getMessage());
            processor.exception(e);
        }
        finally {
            this.close(httpclient, response);
            processor.after();
        }
    }

    public String delete(String url) {
        return this.delete(null, url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String delete(List<Header> headers, String url) {
        this.logger.debug("delete url:" + url);
        String res = null;
        CloseableHttpClient httpclient = this.createClient();
        CloseableHttpResponse response = null;
        try {
            HttpDelete httpDelete = new HttpDelete(url);
            if (headers != null) {
                httpDelete.setHeaders(headers.toArray(new Header[headers.size()]));
            }
            this.setExtraHeaders((HttpRequestBase)httpDelete);
            response = httpclient.execute((HttpUriRequest)httpDelete, (HttpContext)this.httpClientContext);
            this.logger.debug(response.getStatusLine().toString());
            res = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)this.DEFAULT_CHARSET);
            this.logger.debug("responseBody:{}", (Object)res);
            this.close(httpclient, response);
        }
        catch (Exception e) {
            try {
                this.logger.error("http delete error:" + url, (Throwable)e);
                this.addAlarm("delete", url, e.getMessage());
                this.close(httpclient, response);
            }
            catch (Throwable throwable) {
                this.close(httpclient, response);
                throw throwable;
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(List<Header> headers, String url, HttpClientProcessor processor) {
        this.logger.debug("delete url:" + url);
        CloseableHttpClient httpclient = this.createClient();
        CloseableHttpResponse response = null;
        try {
            HttpDelete httpDelete = new HttpDelete(url);
            if (headers != null) {
                httpDelete.setHeaders(headers.toArray(new Header[headers.size()]));
            }
            this.setExtraHeaders((HttpRequestBase)httpDelete);
            processor.before((HttpRequestBase)httpDelete);
            response = httpclient.execute((HttpUriRequest)httpDelete, (HttpContext)this.httpClientContext);
            this.logger.debug(response.getStatusLine().toString());
            processor.complete((HttpResponse)response);
            this.close(httpclient, response);
            processor.after();
        }
        catch (Exception e) {
            try {
                this.logger.error("http delete error:" + url, (Throwable)e);
                this.addAlarm("delete", url, e.getMessage());
                processor.exception(e);
                this.close(httpclient, response);
                processor.after();
            }
            catch (Throwable throwable) {
                this.close(httpclient, response);
                processor.after();
                throw throwable;
            }
        }
    }

    public String getFile(String url, String savePath) {
        return this.getFile(null, url, savePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFile(List<Header> headers, String url, String savePath) {
        this.logger.debug("getFile url:" + url);
        CloseableHttpClient httpclient = this.createClient();
        CloseableHttpResponse response = null;
        OutputStream output = null;
        InputStream fis = null;
        try {
            HttpGet httpGet = new HttpGet(url);
            if (headers != null) {
                httpGet.setHeaders(headers.toArray(new Header[headers.size()]));
            }
            this.setExtraHeaders((HttpRequestBase)httpGet);
            response = httpclient.execute((HttpUriRequest)httpGet, (HttpContext)this.httpClientContext);
            this.logger.debug("get file url:" + response.getStatusLine());
            output = new FileOutputStream(savePath);
            fis = response.getEntity().getContent();
            byte[] b = new byte[1024];
            int j = 0;
            while ((j = fis.read(b)) != -1) {
                ((FileOutputStream)output).write(b, 0, j);
            }
            String string = savePath;
            return string;
        }
        catch (Exception e) {
            this.logger.error("http getFile error:" + url, (Throwable)e);
            this.addAlarm("get file", url, e.getMessage());
            String string = null;
            return string;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
                if (output != null) {
                    output.flush();
                    ((FileOutputStream)output).close();
                }
                if (response != null) {
                    response.close();
                }
                if (httpclient != null) {
                    httpclient.close();
                }
            }
            catch (IOException e) {
                this.logger.error("httpclient getFile close error!", (Throwable)e);
            }
        }
    }

    private void close(CloseableHttpClient httpclient, CloseableHttpResponse response) {
        try {
            if (response != null) {
                response.close();
            }
            if (httpclient != null) {
                httpclient.close();
            }
        }
        catch (IOException e) {
            this.logger.error("httpclient close error!", (Throwable)e);
        }
    }

    public String postFile(String url, String filePath) {
        HashMap<String, Object> fileMap = new HashMap<String, Object>();
        fileMap.put("file", filePath);
        return this.postFile(null, url, fileMap, null);
    }

    public String postFile(String url, String name, String filePath) {
        HashMap<String, Object> fileMap = new HashMap<String, Object>();
        fileMap.put(name, filePath);
        return this.postFile(null, url, fileMap, null);
    }

    public String postFile(String url, Map<String, Object> fileMap, List<NameValuePair> nvps) {
        return this.postFile(null, url, fileMap, nvps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String postFile(List<Header> headers, String url, Map<String, Object> fileMap, List<NameValuePair> nvps) {
        this.logger.debug("postFile url:{},fileMap Size:{}\uff0cnvps:{}", (Object)url, (Object)fileMap.size(), (Object)StringUtil.toJson(nvps));
        String res = null;
        CloseableHttpClient httpclient = this.createClient();
        try {
            Object value;
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).setConnectionRequestTimeout(1000).setSocketTimeout(600000).build();
            HttpPost httpPost = new HttpPost(url);
            if (headers != null) {
                httpPost.setHeaders(headers.toArray(new Header[headers.size()]));
            }
            this.setExtraHeaders((HttpRequestBase)httpPost);
            httpPost.setConfig(requestConfig);
            MultipartEntityBuilder requestBuilder = MultipartEntityBuilder.create().setCharset(this.DEFAULT_CHARSET).setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            if (fileMap != null) {
                for (Map.Entry<String, Object> entry : fileMap.entrySet()) {
                    value = entry.getValue();
                    if (value instanceof File) {
                        this.logger.debug("addBinaryBody file, {}:{}", (Object)entry.getKey(), (Object)((File)entry.getValue()).getAbsolutePath());
                        requestBuilder.addBinaryBody(entry.getKey(), (File)entry.getValue());
                        continue;
                    }
                    if (value instanceof InputStream) {
                        this.logger.debug("addBinaryBody InputStream, {}", (Object)entry.getKey());
                        requestBuilder.addBinaryBody(entry.getKey(), (InputStream)entry.getValue());
                        continue;
                    }
                    if (value instanceof byte[]) {
                        this.logger.debug("addBinaryBody byte[], {}", (Object)entry.getKey());
                        requestBuilder.addBinaryBody(entry.getKey(), (byte[])entry.getValue());
                        continue;
                    }
                    if (!(value instanceof String)) continue;
                    this.logger.debug("addBinaryBody filePath, {}:{}", (Object)entry.getKey(), (Object)((String)entry.getValue()));
                    requestBuilder.addBinaryBody(entry.getKey(), new File((String)entry.getValue()));
                }
            }
            if (nvps != null) {
                for (NameValuePair nvp : nvps) {
                    this.logger.debug("form addPart, {}:{}", (Object)nvp.getName(), (Object)nvp.getValue());
                    value = new StringBody(nvp.getValue(), ContentType.create((String)"text/plain", (Charset)this.DEFAULT_CHARSET));
                    requestBuilder.addPart(nvp.getName(), (ContentBody)value);
                }
            }
            HttpEntity reqEntity = requestBuilder.build();
            httpPost.setEntity(reqEntity);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost, (HttpContext)this.httpClientContext);
            this.logger.debug(response.getStatusLine().toString());
            res = EntityUtils.toString((HttpEntity)response.getEntity());
            this.logger.debug("postFile res:" + res);
        }
        catch (Exception e) {
            this.logger.error("http postFile error:" + url, (Throwable)e);
            this.addAlarm("post file", url, e.getMessage());
        }
        finally {
            try {
                httpclient.close();
            }
            catch (IOException e) {
                this.logger.error("httpclient close error!", (Throwable)e);
            }
        }
        return res;
    }

    public String putFile(String url, String filePath) {
        return this.putFile(null, url, "file", filePath, null);
    }

    public String putFile(String url, String name, String filePath) {
        return this.putFile(null, url, name, filePath, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String putFile(List<Header> headers, String url, String name, String filePath, List<NameValuePair> nvps) {
        this.logger.debug("putFile url:{},filePath:{}", (Object)url, (Object)filePath);
        String res = null;
        CloseableHttpClient httpclient = this.createClient();
        try {
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).setConnectionRequestTimeout(1000).setSocketTimeout(600000).build();
            HttpPut httpPut = new HttpPut(url);
            if (headers != null) {
                httpPut.setHeaders(headers.toArray(new Header[headers.size()]));
            }
            this.setExtraHeaders((HttpRequestBase)httpPut);
            httpPut.setConfig(requestConfig);
            FileBody bin = new FileBody(new File(filePath));
            long len = bin.getContentLength();
            this.logger.debug("putFile size:" + len / 1024L + "KB");
            MultipartEntityBuilder requestBuilder = MultipartEntityBuilder.create().addBinaryBody(name, new File(filePath)).setCharset(this.DEFAULT_CHARSET).setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            for (NameValuePair nvp : nvps) {
                requestBuilder.addTextBody(nvp.getName(), nvp.getValue());
            }
            HttpEntity reqEntity = requestBuilder.build();
            httpPut.setEntity(reqEntity);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPut, (HttpContext)this.httpClientContext);
            this.logger.debug(response.getStatusLine().toString());
            res = EntityUtils.toString((HttpEntity)response.getEntity());
            this.logger.debug("putFile res:" + res);
        }
        catch (Exception e) {
            this.logger.error("http putFile error:" + url, (Throwable)e);
            this.addAlarm("put file", url, e.getMessage());
        }
        finally {
            try {
                httpclient.close();
            }
            catch (IOException e) {
                this.logger.error("httpclient close error!", (Throwable)e);
            }
        }
        return res;
    }

    private void setExtraHeaders(HttpRequestBase httpEntity) {
        if (!this.withExtra) {
            return;
        }
        String requestId = WebContext.getRequestId();
        String at = WebContext.getRequestAt();
        String ht = WebContext.getRequestHt();
        String token = WebContext.getRequestToken();
        String authorization = WebContext.getRequestAuthorization();
        if (!StringUtil.isEmpty(requestId)) {
            httpEntity.setHeader("jsm-req-id", requestId);
        }
        if (!StringUtil.isEmpty(at)) {
            httpEntity.setHeader("at", at);
        }
        if (!StringUtil.isEmpty(ht)) {
            httpEntity.setHeader("ht", ht);
        }
        if (!StringUtil.isEmpty(token)) {
            httpEntity.setHeader("jsm-token", token);
        }
        if (!StringUtil.isEmpty(authorization)) {
            httpEntity.setHeader(WebContext.JSM_AUTHORIZATION, authorization);
        }
    }

    private CloseableHttpClient createClient() {
        SSLConnectionSocketFactory sslcsf = null;
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial((org.apache.http.ssl.TrustStrategy)new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
            sslcsf = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)new NoopHostnameVerifier());
        }
        catch (Exception e) {
            this.logger.error("create ssl socket factory error!", (Throwable)e);
        }
        HttpClientBuilder hcb = HttpClientBuilder.create();
        if (this.proxyHost != null) {
            hcb.setProxy(this.proxyHost);
        }
        if (sslcsf != null) {
            hcb.setSSLSocketFactory(sslcsf);
        }
        hcb.setRetryHandler(this.myRetryHandler);
        hcb.setConnectionManager((HttpClientConnectionManager)this.connManager);
        return hcb.build();
    }
}

