/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.http;

import com.jsmframe.utils.LogUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.NameValuePair;
import org.apache.http.client.CookieStore;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;

public class HttpBrowser {
    private Logger logger = LogUtil.log(HttpBrowser.class);
    private List<Header> headers;
    private HttpClientContext context = null;
    private CookieStore cookieStore = null;
    private HttpHost proxyHost = null;

    private HttpBrowser(List<Header> headers, HttpHost proxyHost) {
        this.headers = headers != null ? headers : HttpBrowser.getDefaultHeader();
        this.context = HttpClientContext.create();
        this.cookieStore = new BasicCookieStore();
        this.proxyHost = proxyHost;
    }

    private CloseableHttpClient createClient() {
        SSLConnectionSocketFactory sslcsf = null;
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
            sslcsf = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)new NoopHostnameVerifier());
        }
        catch (Exception e) {
            this.logger.error("create ssl socket factory error!", (Throwable)e);
        }
        HttpClientBuilder hcb = HttpClientBuilder.create().setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy()).setDefaultCookieStore(this.cookieStore).setDefaultHeaders(this.headers);
        if (this.proxyHost != null) {
            hcb.setProxy(this.proxyHost);
        }
        if (sslcsf != null) {
            hcb.setSSLSocketFactory((LayeredConnectionSocketFactory)sslcsf);
        }
        return hcb.build();
    }

    private HttpGet proxyHttpGet(HttpGet httpGet) {
        if (this.proxyHost != null) {
            RequestConfig config = RequestConfig.custom().setProxy(this.proxyHost).build();
            httpGet.setConfig(config);
        }
        return httpGet;
    }

    private HttpPost proxyHttpPost(HttpPost httpPost) {
        if (this.proxyHost != null) {
            RequestConfig config = RequestConfig.custom().setProxy(this.proxyHost).build();
            httpPost.setConfig(config);
        }
        return httpPost;
    }

    private HttpPut proxyHttpPut(HttpPut httpPut) {
        if (this.proxyHost != null) {
            RequestConfig config = RequestConfig.custom().setProxy(this.proxyHost).build();
            httpPut.setConfig(config);
        }
        return httpPut;
    }

    private HttpDelete proxyHttpDelete(HttpDelete httpDelete) {
        if (this.proxyHost != null) {
            RequestConfig config = RequestConfig.custom().setProxy(this.proxyHost).build();
            httpDelete.setConfig(config);
        }
        return httpDelete;
    }

    public static HttpBrowser open() {
        return HttpBrowser.open(HttpBrowser.getDefaultHeader());
    }

    public static HttpBrowser open(List<Header> headers) {
        HttpBrowser httpBrowser = new HttpBrowser(headers, null);
        return httpBrowser;
    }

    public static HttpBrowser open(List<Header> headers, HttpHost proxyHost) {
        HttpBrowser httpBrowser = new HttpBrowser(headers, proxyHost);
        return httpBrowser;
    }

    public static HttpBrowser open(HttpHost proxyHost) {
        HttpBrowser httpBrowser = new HttpBrowser(null, proxyHost);
        return httpBrowser;
    }

    public String get(String url) {
        return this.get(url, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String url, String charset) {
        this.logger.info("get url:" + url);
        String res = null;
        CloseableHttpClient httpClient = null;
        try {
            httpClient = this.createClient();
            HttpGet httpGet = new HttpGet(url);
            httpGet = this.proxyHttpGet(httpGet);
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet, (HttpContext)this.context);){
                this.logger.info("get url status:" + response.getStatusLine());
                res = EntityUtils.toString((HttpEntity)response.getEntity(), (String)charset);
            }
        }
        catch (Exception e) {
            this.logger.error("http get error:" + url, (Throwable)e);
        }
        finally {
            if (httpClient != null) {
                try {
                    httpClient.close();
                }
                catch (Exception e) {
                    this.logger.error("close httpClient error:" + url, (Throwable)e);
                }
            }
        }
        return res;
    }

    public String post(String url, List<NameValuePair> nvps) {
        return this.post(url, nvps, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String post(String url, List<NameValuePair> nvps, String charset) {
        this.logger.info("post url:" + url);
        String res = null;
        CloseableHttpClient httpClient = null;
        try {
            httpClient = this.createClient();
            HttpPost httpPost = new HttpPost(url);
            httpPost = this.proxyHttpPost(httpPost);
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, charset));
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost, (HttpContext)this.context);){
                this.logger.info(response.getStatusLine().toString());
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode >= 300 && statusCode < 400) {
                    Header locationHeader = response.getFirstHeader("location");
                    if (locationHeader != null) {
                        res = locationHeader.toString();
                    }
                } else {
                    res = EntityUtils.toString((HttpEntity)response.getEntity(), (String)charset);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("http get error:" + url, (Throwable)e);
        }
        finally {
            if (httpClient != null) {
                try {
                    httpClient.close();
                }
                catch (Exception e) {
                    this.logger.error("close httpClient error:" + url, (Throwable)e);
                }
            }
        }
        return res;
    }

    public String post(String url, String strEntity) {
        return this.post(url, strEntity, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String post(String url, String strEntity, String charset) {
        this.logger.info("post url:" + url);
        String res = null;
        CloseableHttpClient httpClient = null;
        try {
            httpClient = this.createClient();
            HttpPost httpPost = new HttpPost(url);
            httpPost = this.proxyHttpPost(httpPost);
            StringEntity entity = new StringEntity(strEntity, charset);
            entity.setContentEncoding(charset);
            entity.setContentType("application/json");
            httpPost.setEntity((HttpEntity)entity);
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost, (HttpContext)this.context);){
                this.logger.info(response.getStatusLine().toString());
                res = EntityUtils.toString((HttpEntity)response.getEntity(), (String)charset);
            }
        }
        catch (Exception e) {
            this.logger.error("http post error:" + url, (Throwable)e);
        }
        finally {
            if (httpClient != null) {
                try {
                    httpClient.close();
                }
                catch (Exception e) {
                    this.logger.error("close httpClient error:" + url, (Throwable)e);
                }
            }
        }
        return res;
    }

    public String put(String url, String strEntity) {
        return this.put(url, strEntity, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String put(String url, String strEntity, String charset) {
        this.logger.info("put url:" + url);
        String res = null;
        CloseableHttpClient httpClient = null;
        try {
            httpClient = this.createClient();
            HttpPut httpPut = new HttpPut(url);
            httpPut = this.proxyHttpPut(httpPut);
            StringEntity entity = new StringEntity(strEntity, charset);
            entity.setContentEncoding(charset);
            entity.setContentType("application/json");
            httpPut.setEntity((HttpEntity)entity);
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPut, (HttpContext)this.context);){
                this.logger.info(response.getStatusLine().toString());
                res = EntityUtils.toString((HttpEntity)response.getEntity(), (String)charset);
            }
        }
        catch (Exception e) {
            this.logger.error("http put error:" + url, (Throwable)e);
        }
        finally {
            if (httpClient != null) {
                try {
                    httpClient.close();
                }
                catch (Exception e) {
                    this.logger.error("close httpClient error:" + url, (Throwable)e);
                }
            }
        }
        return res;
    }

    public String delete(String url) {
        return this.delete(url, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String delete(String url, String charset) {
        this.logger.info("delete url:" + url);
        String res = null;
        CloseableHttpClient httpClient = null;
        try {
            httpClient = this.createClient();
            HttpDelete httpDelete = new HttpDelete(url);
            httpDelete = this.proxyHttpDelete(httpDelete);
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpDelete, (HttpContext)this.context);){
                this.logger.info("delete url status:" + response.getStatusLine());
                res = EntityUtils.toString((HttpEntity)response.getEntity(), (String)charset);
            }
        }
        catch (Exception e) {
            this.logger.error("http delete error:" + url, (Throwable)e);
        }
        finally {
            if (httpClient != null) {
                try {
                    httpClient.close();
                }
                catch (Exception e) {
                    this.logger.error("close httpClient error:" + url, (Throwable)e);
                }
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getImage(String url, String savePath) {
        this.logger.info("getImage url:" + url);
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        OutputStream output = null;
        InputStream fis = null;
        try {
            httpClient = this.createClient();
            HttpGet httpGet = new HttpGet(url);
            httpGet = this.proxyHttpGet(httpGet);
            response = httpClient.execute((HttpUriRequest)httpGet, (HttpContext)this.context);
            this.logger.info("get image url:" + response.getStatusLine());
            output = new FileOutputStream(savePath);
            fis = response.getEntity().getContent();
            byte[] b = new byte[1024];
            int j = 0;
            while ((j = fis.read(b)) != -1) {
                ((FileOutputStream)output).write(b, 0, j);
            }
            String string = savePath;
            return string;
        }
        catch (Exception e) {
            this.logger.error("http get error:" + url, (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
                if (output != null) {
                    output.flush();
                    ((FileOutputStream)output).close();
                }
                if (response != null) {
                    response.close();
                }
                if (httpClient != null) {
                    httpClient.close();
                }
            }
            catch (IOException e) {
                this.logger.error("httpClient getImage close error!", (Throwable)e);
            }
        }
    }

    public String postImage(String url, String imagePath) {
        return this.postImage(url, imagePath, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String postImage(String url, String imagePath, String charset) {
        this.logger.info("postImage url:" + url);
        String res = null;
        try {
            CloseableHttpClient httpClient = this.createClient();
            HttpPost httpPost = new HttpPost(url);
            httpPost = this.proxyHttpPost(httpPost);
            FileBody bin = new FileBody(new File(imagePath));
            long len = bin.getContentLength();
            this.logger.info("postImage image size:" + len / 1024L + "KB");
            HttpEntity reqEntity = MultipartEntityBuilder.create().addPart("media", (ContentBody)bin).build();
            httpPost.setEntity(reqEntity);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost, (HttpContext)this.context);
            try {
                this.logger.info(response.getStatusLine().toString());
                res = EntityUtils.toString((HttpEntity)response.getEntity(), (String)charset);
                this.logger.info("postImage res:" + res);
            }
            catch (Exception e) {
                this.logger.error("http get read error:" + url, (Throwable)e);
            }
            finally {
                response.close();
                httpClient.close();
            }
        }
        catch (Exception e) {
            this.logger.error("http get error:" + url, (Throwable)e);
        }
        return res;
    }

    public void addCookie(String name, String value, String domain, String path) {
        BasicClientCookie cookie = new BasicClientCookie(name, value);
        cookie.setDomain(domain);
        cookie.setPath(path);
        this.cookieStore.addCookie((Cookie)cookie);
    }

    private static List<Header> getDefaultHeader() {
        ArrayList<Header> headers = new ArrayList<Header>();
        headers.add((Header)new BasicHeader("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8"));
        headers.add((Header)new BasicHeader("Accept-Encoding", "gzip, deflate, sdch"));
        headers.add((Header)new BasicHeader("Accept-Language", "zh-CN,zh;q=0.8"));
        headers.add((Header)new BasicHeader("Cache-Control", "max-age=0"));
        headers.add((Header)new BasicHeader("Connection", "keep-alive"));
        headers.add((Header)new BasicHeader("User-Agent", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.94 Safari/537.36"));
        return headers;
    }
}

