/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.elastic;

import com.jsmframe.http.HttpAsyncClient;
import com.jsmframe.http.HttpClient;
import com.jsmframe.stat.model.Alarm;
import com.jsmframe.utils.SystemUtil;
import java.util.List;
import org.apache.http.HttpResponse;
import org.apache.http.concurrent.FutureCallback;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.status.StatusLogger;

public class ElasticClient {
    private Logger LOGGER = StatusLogger.getLogger();
    private String username;
    private String password;
    private String indexAddress;
    private String type = "_doc";
    private String postAddress;
    private String header;
    private HttpClient httpClient = new HttpClient();
    private HttpAsyncClient httpAsyncClient = new HttpAsyncClient();

    public ElasticClient(String indexAddress) {
        this.httpClient.setWithExtra(false);
        this.indexAddress = indexAddress;
        this.postAddress = indexAddress + "/" + this.type;
        String idx = indexAddress.substring(indexAddress.lastIndexOf("/") + 1);
        this.header = String.format("{\"index\":{\"_index\":\"%s\",\"_type\":\"%s\"}}", idx, this.type);
    }

    public ElasticClient(String indexAddress, String type) {
        this.indexAddress = indexAddress;
        if (type != null) {
            this.type = type;
        }
        this.postAddress = indexAddress + "/" + this.type;
        String idx = indexAddress.substring(indexAddress.lastIndexOf("/") + 1);
        this.header = String.format("{\"index\":{\"_index\":\"%s\",\"_type\":\"%s\"}}", idx, type);
    }

    public ElasticClient(String indexAddress, String type, String username, String password) {
        this.indexAddress = indexAddress;
        if (type != null) {
            this.type = type;
        }
        this.postAddress = indexAddress + "/" + this.type;
        this.username = username;
        this.password = password;
        String idx = indexAddress.substring(indexAddress.lastIndexOf("/") + 1);
        this.header = String.format("{\"index\":{\"_index\":\"%s\",\"_type\":\"%s\"}}", idx, type);
    }

    public boolean checkIndex() {
        this.LOGGER.debug("ElasticClient checkIndex:" + this.indexAddress);
        String res = this.httpClient.get(this.indexAddress);
        this.LOGGER.debug("ElasticClient checkIndex res:" + res);
        return res == null ? false : !res.contains("\"status\":404");
    }

    public String createIndex(String jsonOption) {
        this.LOGGER.debug("ElasticClient createIndex:" + jsonOption);
        String res = this.httpClient.put(this.indexAddress, jsonOption);
        this.LOGGER.debug("ElasticClient createIndex res:" + res);
        return res;
    }

    public String deleteIndex() {
        this.LOGGER.debug("ElasticClient deleteIndex:" + this.indexAddress);
        String res = this.httpClient.delete(this.indexAddress);
        this.LOGGER.debug("ElasticClient deleteIndex res:" + res);
        return res;
    }

    public String recreateIndex(String jsonOption) {
        this.deleteIndex();
        return this.createIndex(jsonOption);
    }

    public boolean createIndexIfNotExists(String jsonOption) {
        boolean exists = this.checkIndex();
        if (!exists) {
            String res = this.createIndex(jsonOption);
            return res == null ? false : res.contains("\"result\":\"created\"");
        }
        this.LOGGER.info("ElasticClient index exists:" + this.indexAddress);
        return exists;
    }

    public void post(String jsonData) {
        this.LOGGER.debug("ElasticClient post:" + jsonData);
        this.httpAsyncClient.post(this.postAddress, jsonData, (FutureCallback)new FutureCallback<HttpResponse>(){

            public void completed(HttpResponse result) {
                ElasticClient.this.LOGGER.debug("httpAsyncClient post res:" + result.getEntity());
            }

            public void failed(Exception ex) {
                ElasticClient.this.LOGGER.debug("httpAsyncClient post failed!");
                SystemUtil.addAlarm(new Alarm("ElasticClient", "httpAsyncClient post failed!"));
            }

            public void cancelled() {
                ElasticClient.this.LOGGER.debug("httpAsyncClient post cancelled!");
                SystemUtil.addAlarm(new Alarm("ElasticClient", "httpAsyncClient post cancelled!"));
            }
        });
    }

    public void post(String id, String jsonData) {
        this.LOGGER.debug("ElasticClient post:" + jsonData);
        this.httpAsyncClient.post(this.postAddress + "/" + id, jsonData, (FutureCallback)new FutureCallback<HttpResponse>(){

            public void completed(HttpResponse result) {
                ElasticClient.this.LOGGER.debug("httpAsyncClient post res:" + result.getEntity());
            }

            public void failed(Exception ex) {
                ElasticClient.this.LOGGER.debug("httpAsyncClient post failed!");
                SystemUtil.addAlarm(new Alarm("ElasticClient", "httpAsyncClient post failed!"));
            }

            public void cancelled() {
                ElasticClient.this.LOGGER.debug("httpAsyncClient post cancelled!");
                SystemUtil.addAlarm(new Alarm("ElasticClient", "httpAsyncClient post cancelled!"));
            }
        });
    }

    public void postBatch(List<String> jsonDataList) {
        if (jsonDataList == null || jsonDataList.isEmpty()) {
            return;
        }
        this.LOGGER.debug("ElasticClient post jsonDataList size:" + jsonDataList.size());
        StringBuilder sb = new StringBuilder();
        for (String jsonData : jsonDataList) {
            sb.append(this.header).append("\n");
            sb.append(jsonData).append("\n");
        }
        this.httpAsyncClient.post(this.postAddress + "/_bulk", sb.toString(), (FutureCallback)new FutureCallback<HttpResponse>(){

            public void completed(HttpResponse result) {
                ElasticClient.this.LOGGER.debug("httpAsyncClient post res:" + result.getEntity());
            }

            public void failed(Exception ex) {
                ElasticClient.this.LOGGER.debug("httpAsyncClient post failed!");
                SystemUtil.addAlarm(new Alarm("ElasticClient", "httpAsyncClient post failed!"));
            }

            public void cancelled() {
                ElasticClient.this.LOGGER.debug("httpAsyncClient post cancelled!");
                SystemUtil.addAlarm(new Alarm("ElasticClient", "httpAsyncClient post cancelled!"));
            }
        });
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getIndexAddress() {
        return this.indexAddress;
    }

    public void setIndexAddress(String indexAddress) {
        this.indexAddress = indexAddress;
    }
}

