/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.disruptor;

import com.jsmframe.disruptor.Processor;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.EventTranslatorOneArg;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.TimeoutBlockingWaitStrategy;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.status.StatusLogger;

public class StringDisruptor {
    private static Logger logger = StatusLogger.getLogger();
    private EventTranslatorOneArg<MessageEvent, String> translator = new MessageEventTranslator();
    private Disruptor<MessageEvent> disruptor;
    private Processor<MessageEvent> processor;
    private int bufferSize = 1024;
    private WaitStrategy waitStrategy = new TimeoutBlockingWaitStrategy(10L, TimeUnit.MILLISECONDS);
    private ProducerType producerType = ProducerType.MULTI;

    public StringDisruptor(Processor<MessageEvent> processor) {
        this.processor = processor;
        this.init();
    }

    public StringDisruptor(Processor<MessageEvent> processor, int bufferSize) {
        this.processor = processor;
        if (bufferSize > 0) {
            this.bufferSize = bufferSize;
        }
        this.init();
    }

    public StringDisruptor(Processor<MessageEvent> processor, int bufferSize, WaitStrategy waitStrategy) {
        this.processor = processor;
        if (bufferSize > 0) {
            this.bufferSize = bufferSize;
        }
        if (waitStrategy != null) {
            this.waitStrategy = waitStrategy;
        }
        this.init();
    }

    public StringDisruptor(Processor<MessageEvent> processor, int bufferSize, WaitStrategy waitStrategy, ProducerType producerType) {
        this.processor = processor;
        if (bufferSize > 0) {
            this.bufferSize = bufferSize;
        }
        if (waitStrategy != null) {
            this.waitStrategy = waitStrategy;
        }
        if (producerType != null) {
            this.producerType = producerType;
        }
        this.init();
    }

    private void init() {
        if (this.processor == null) {
            throw new RuntimeException("processor can't be null.");
        }
        this.disruptor = new Disruptor((EventFactory)new MessageEventFactory(), this.bufferSize, (ThreadFactory)new MessageThreadFactory(), this.producerType, this.waitStrategy);
        this.disruptor.handleEventsWith(new EventHandler[]{new MessageEventHandler()});
        this.disruptor.setDefaultExceptionHandler((ExceptionHandler)new MessageExceptionHandler());
        this.disruptor.start();
    }

    public void shutdown() {
        if (this.disruptor != null) {
            this.disruptor.shutdown();
        }
    }

    public void pushMessage(String message) {
        if (this.disruptor != null) {
            this.disruptor.publishEvent(this.translator, (Object)message);
        } else {
            logger.error("pushMessage error. ringBuffer is null!");
        }
    }

    public class MessageExceptionHandler
    implements ExceptionHandler<MessageEvent> {
        public void handleEventException(Throwable ex, long sequence, MessageEvent event) {
            ex.printStackTrace();
        }

        public void handleOnStartException(Throwable ex) {
            ex.printStackTrace();
        }

        public void handleOnShutdownException(Throwable ex) {
            ex.printStackTrace();
        }
    }

    public class MessageEventHandler
    implements EventHandler<MessageEvent> {
        public void onEvent(MessageEvent messageEvent, long sequence, boolean endOfBatch) throws Exception {
            StringDisruptor.this.processor.process(messageEvent, sequence, endOfBatch);
        }
    }

    public class MessageThreadFactory
    implements ThreadFactory {
        int index = 0;

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "jsm-str-drp-" + (this.index < 0x7FFFFFFE ? (this.index = this.index + 1) : 0));
        }
    }

    public class MessageEventTranslator
    implements EventTranslatorOneArg<MessageEvent, String> {
        public void translateTo(MessageEvent messageEvent, long sequence, String message) {
            messageEvent.setMessage(message);
        }
    }

    public class MessageEventFactory
    implements EventFactory<MessageEvent> {
        public MessageEvent newInstance() {
            return new MessageEvent();
        }
    }

    public class MessageEvent {
        private String message;

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }
}

