/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.disruptor;

import com.jsmframe.stat.model.Alarm;
import com.jsmframe.utils.SystemUtil;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.EventTranslatorOneArg;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.TimeoutBlockingWaitStrategy;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.status.StatusLogger;

public class JsmDisruptor<T> {
    private static Logger logger = StatusLogger.getLogger();
    private EventTranslatorOneArg<MessageEvent<T>, T> translator = new MessageEventTranslator();
    private Disruptor<MessageEvent<T>> disruptor;
    private EventHandler<MessageEvent<T>> eventEventHandler;
    private int bufferSize = 1024;
    private WaitStrategy waitStrategy = new TimeoutBlockingWaitStrategy(10L, TimeUnit.MILLISECONDS);
    private EventFactory eventFactory = new MessageEventFactory();
    private MessageExceptionHandler exceptionHandler = new MessageExceptionHandler();
    private ProducerType producerType = ProducerType.MULTI;
    public String name = "jsm";

    public JsmDisruptor(EventHandler<MessageEvent<T>> eventEventHandler) {
        this.eventEventHandler = eventEventHandler;
        this.init();
    }

    public JsmDisruptor(EventHandler<MessageEvent<T>> eventEventHandler, int bufferSize) {
        this.eventEventHandler = eventEventHandler;
        if (bufferSize > 0) {
            this.bufferSize = bufferSize;
        }
        this.init();
    }

    public JsmDisruptor(EventHandler<MessageEvent<T>> eventEventHandler, int bufferSize, WaitStrategy waitStrategy) {
        this.eventEventHandler = eventEventHandler;
        if (bufferSize > 0) {
            this.bufferSize = bufferSize;
        }
        if (waitStrategy != null) {
            this.waitStrategy = waitStrategy;
        }
        this.init();
    }

    public JsmDisruptor(EventHandler<MessageEvent<T>> eventEventHandler, int bufferSize, WaitStrategy waitStrategy, ProducerType producerType) {
        this.eventEventHandler = eventEventHandler;
        if (bufferSize > 0) {
            this.bufferSize = bufferSize;
        }
        if (waitStrategy != null) {
            this.waitStrategy = waitStrategy;
        }
        if (producerType != null) {
            this.producerType = producerType;
        }
        this.init();
    }

    private void init() {
        if (this.eventEventHandler == null) {
            throw new RuntimeException("eventEventHandler can't be null.");
        }
        this.disruptor = new Disruptor(this.eventFactory, this.bufferSize, (ThreadFactory)new MessageThreadFactory(), this.producerType, this.waitStrategy);
        this.disruptor.handleEventsWith(new EventHandler[]{this.eventEventHandler});
        this.disruptor.setDefaultExceptionHandler((ExceptionHandler)this.exceptionHandler);
        this.disruptor.start();
    }

    public void shutdown() {
        if (this.disruptor != null) {
            this.disruptor.shutdown();
        }
    }

    public void pushMessage(T message) {
        this.pushMessage(message, true);
    }

    public void pushMessage(T message, boolean useTryPub) {
        if (this.disruptor != null) {
            if ((double)this.disruptor.getRingBuffer().remainingCapacity() < (double)this.bufferSize * 0.01) {
                logger.warn(this.name + " ringBuffer remain: " + this.disruptor.getRingBuffer().remainingCapacity());
            }
            if (useTryPub) {
                this.disruptor.getRingBuffer().tryPublishEvent(this.translator, message);
            } else {
                this.disruptor.getRingBuffer().publishEvent(this.translator, message);
            }
        } else {
            logger.error("pushMessage error. ringBuffer is null!");
        }
    }

    public class MessageExceptionHandler
    implements ExceptionHandler<MessageEvent<T>> {
        public void handleEventException(Throwable ex, long sequence, MessageEvent<T> event) {
            SystemUtil.addAlarm(new Alarm("JsmDisruptor", JsmDisruptor.this.name + ",handleEventException:" + ex.getMessage()));
            ex.printStackTrace();
        }

        public void handleOnStartException(Throwable ex) {
            SystemUtil.addAlarm(new Alarm("JsmDisruptor", JsmDisruptor.this.name + ",handleOnStartException:" + ex.getMessage()));
            ex.printStackTrace();
        }

        public void handleOnShutdownException(Throwable ex) {
            SystemUtil.addAlarm(new Alarm("JsmDisruptor", JsmDisruptor.this.name + ",handleOnShutdownException:" + ex.getMessage()));
            ex.printStackTrace();
        }
    }

    public class MessageThreadFactory
    implements ThreadFactory {
        int index = 0;

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "drp-" + JsmDisruptor.this.name + "-" + (this.index < 0x7FFFFFFE ? (this.index = this.index + 1) : 0));
        }
    }

    public class MessageEventTranslator
    implements EventTranslatorOneArg<MessageEvent<T>, T> {
        public void translateTo(MessageEvent<T> messageEvent, long sequence, T message) {
            messageEvent.message = message;
        }
    }

    public class MessageEventFactory
    implements EventFactory<MessageEvent> {
        public MessageEvent newInstance() {
            return new MessageEvent();
        }
    }

    public class MessageEvent<T> {
        public T message;
    }
}

