/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.context;

import com.jsmframe.context.SpringContext;
import com.jsmframe.context.WebContext;
import com.jsmframe.service.CacheService;
import com.jsmframe.service.JsmAppListenerService;
import com.jsmframe.utils.LogUtil;
import com.jsmframe.utils.QuartzUtil;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.slf4j.Logger;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class JsmInitListener
implements ServletContextListener {
    private static Logger logger = LogUtil.log(JsmInitListener.class);

    public void contextDestroyed(ServletContextEvent sce) {
        WebApplicationContext wac = WebApplicationContextUtils.getWebApplicationContext((ServletContext)sce.getServletContext());
        JsmAppListenerService appListenerService = SpringContext.getBean(JsmAppListenerService.class, wac);
        if (appListenerService != null) {
            appListenerService.close(sce);
        }
        QuartzUtil.shutdownJobs();
        CacheService cacheService = SpringContext.getBean(CacheService.class);
        if (cacheService != null) {
            cacheService.close();
        }
        logger.info("app close complete!");
    }

    public void contextInitialized(ServletContextEvent sce) {
        WebContext.setContextPath(sce.getServletContext().getContextPath());
        WebContext.setRealPath(sce.getServletContext().getRealPath("/"));
        System.setProperty("file.encoding", "utf-8");
        logger.info("jsm-frame init complete!");
        WebApplicationContext wac = WebApplicationContextUtils.getWebApplicationContext((ServletContext)sce.getServletContext());
        JsmAppListenerService appListenerService = SpringContext.getBean(JsmAppListenerService.class, wac);
        if (appListenerService != null) {
            appListenerService.init(sce);
        }
        this.appContextInitialized(sce);
        logger.info("app init complete!");
    }

    protected void appContextInitialized(ServletContextEvent sce) {
    }
}

