/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.context;

import com.jsmframe.context.WebContext;
import com.jsmframe.utils.LogUtil;
import com.jsmframe.utils.PropUtil;
import com.jsmframe.utils.StringUtil;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;

public class AppContext {
    private static Logger logger = LogUtil.log(AppContext.class);
    private static Map<String, String> propMap = new HashMap<String, String>();
    private static boolean devModel = true;
    private static boolean jedisSession = false;

    public static boolean isDevModel() {
        return devModel;
    }

    public static boolean isJedisSession() {
        return jedisSession;
    }

    public static String getDirect(String key) {
        String val = PropUtil.get(key, "app.properties");
        if (val != null) {
            return val;
        }
        val = PropUtil.get(key, "project.properties");
        if (val != null) {
            return val;
        }
        return null;
    }

    public static String get(String key, String defaultVal) {
        String res = AppContext.get(key);
        return res == null ? defaultVal : res;
    }

    public static String get(String key) {
        return propMap.get(key);
    }

    public static Integer getAsInteger(String key) {
        return AppContext.getAsInteger(key, null);
    }

    public static Integer getAsInteger(String key, Integer defaultVal) {
        try {
            String val = AppContext.get(key);
            return val == null ? defaultVal : StringUtil.toInteger(val, defaultVal);
        }
        catch (Exception e) {
            logger.error("getAsInteger error! key {}", (Object)key);
            return null;
        }
    }

    public static Short getAsShort(String key) {
        return AppContext.getAsShort(key, null);
    }

    public static Short getAsShort(String key, Short defaultVal) {
        try {
            String val = AppContext.get(key);
            return val == null ? defaultVal : StringUtil.toShort(val, defaultVal);
        }
        catch (Exception e) {
            logger.error("getAsShort error! key {}", (Object)key);
            return null;
        }
    }

    public static Byte getAsByte(String key) {
        return AppContext.getAsByte(key, null);
    }

    public static Byte getAsByte(String key, Byte defaultVal) {
        try {
            String val = AppContext.get(key);
            return val == null ? defaultVal : StringUtil.toByte(val, defaultVal);
        }
        catch (Exception e) {
            logger.error("getAsByte error! key {}", (Object)key);
            return null;
        }
    }

    public static Float getAsFloat(String key) {
        return AppContext.getAsFloat(key, null);
    }

    public static Float getAsFloat(String key, Float defaultVal) {
        try {
            String val = AppContext.get(key);
            return val == null ? defaultVal : StringUtil.toFloat(val, defaultVal);
        }
        catch (Exception e) {
            logger.error("getAsFloat error! key {}", (Object)key);
            return null;
        }
    }

    public static Long getAsLong(String key) {
        return AppContext.getAsLong(key, null);
    }

    public static Long getAsLong(String key, Long defaultVal) {
        try {
            String val = AppContext.get(key);
            return val == null ? defaultVal : StringUtil.toLong(val, defaultVal);
        }
        catch (Exception e) {
            logger.error("getAsLong error! key {}", (Object)key);
            return null;
        }
    }

    public static Boolean getAsBoolean(String key) {
        return AppContext.getAsBoolean(key, null);
    }

    public static Boolean getAsBoolean(String key, Boolean defaultVal) {
        try {
            String val = AppContext.get(key);
            return val == null ? defaultVal : StringUtil.toBoolean(val, defaultVal);
        }
        catch (Exception e) {
            logger.error("getAsBoolean error! key {}", (Object)key);
            return null;
        }
    }

    private static void init() {
        String swaggerHeaders;
        AppContext.loadPropMap();
        devModel = AppContext.getAsBoolean("dev.model");
        jedisSession = AppContext.getAsBoolean("jedis.session");
        logger.info("devModel:{}", (Object)devModel);
        logger.info("jedisSession:{}", (Object)jedisSession);
        Properties prop = System.getProperties();
        String httpProxyHost = AppContext.get("http.proxyHost");
        String httpProxyPort = AppContext.get("http.proxyPort");
        String httpNonProxyHosts = AppContext.get("http.nonProxyHosts");
        String httpsProxyHost = AppContext.get("https.proxyHost");
        String httpsProxyPort = AppContext.get("https.proxyPort");
        String httpsNonProxyHosts = AppContext.get("https.nonProxyHosts");
        String ftpProxyHost = AppContext.get("ftp.proxyHost");
        String ftpProxyPort = AppContext.get("ftp.proxyPort");
        String ftpNonProxyHosts = AppContext.get("ftp.nonProxyHosts");
        String socksProxyHost = AppContext.get("socks.proxyHost");
        String socksProxyPort = AppContext.get("socks.proxyPort");
        String proxyUsername = AppContext.get("proxy.username");
        String proxyPassword = AppContext.get("proxy.password");
        if (!StringUtil.isEmpty(httpProxyHost)) {
            logger.info("http.proxyHost:{}", (Object)httpProxyHost);
            logger.info("http.proxyPort:{}", (Object)httpProxyPort);
            logger.info("http.nonProxyHosts:{}", (Object)httpNonProxyHosts);
            prop.setProperty("http.proxyHost", httpProxyHost);
            prop.setProperty("http.proxyPort", httpProxyPort);
            prop.setProperty("http.nonProxyHosts", httpNonProxyHosts);
        }
        if (!StringUtil.isEmpty(httpsProxyHost)) {
            logger.info("https.proxyHost:{}", (Object)httpsProxyHost);
            logger.info("https.proxyPort:{}", (Object)httpsProxyPort);
            logger.info("https.nonProxyHosts:{}", (Object)httpsNonProxyHosts);
            prop.setProperty("https.proxyHost", httpsProxyHost);
            prop.setProperty("https.proxyPort", httpsProxyPort);
            prop.setProperty("https.nonProxyHosts", httpsNonProxyHosts);
        }
        if (!StringUtil.isEmpty(ftpProxyHost)) {
            logger.info("ftp.proxyHost:{}", (Object)ftpProxyHost);
            logger.info("ftp.proxyPort:{}", (Object)ftpProxyPort);
            logger.info("ftp.nonProxyHosts:{}", (Object)ftpNonProxyHosts);
            prop.setProperty("ftp.proxyHost", ftpProxyHost);
            prop.setProperty("ftp.proxyPort", ftpProxyPort);
            prop.setProperty("ftp.nonProxyHosts", ftpNonProxyHosts);
        }
        if (!StringUtil.isEmpty(socksProxyHost)) {
            logger.info("socks.proxyHost:{}", (Object)socksProxyHost);
            logger.info("socks.proxyPort:{}", (Object)socksProxyPort);
            prop.setProperty("socksProxyHost", socksProxyHost);
            prop.setProperty("socksProxyPort", socksProxyPort);
        }
        if (!StringUtil.isEmpty(proxyUsername)) {
            logger.info("proxy.username:{}", (Object)proxyUsername);
            final String username = proxyUsername;
            final String password = proxyPassword;
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(username, password.toCharArray());
                }
            });
        }
        if (!StringUtil.isEmpty(swaggerHeaders = AppContext.get("swagger.apis.headers"))) {
            String[] headersArr = swaggerHeaders.split(";");
            WebContext.JSM_AUTHORIZATION = headersArr[0].split("\\|")[0];
        }
    }

    private static void loadPropMap() {
        String propFile = "project.properties";
        logger.info("load:{} ", (Object)propFile);
        Properties properties = PropUtil.getProperties(propFile);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            propMap.put((String)entry.getKey(), (String)entry.getValue());
        }
        propFile = "app.properties";
        logger.info("load:{} ", (Object)propFile);
        properties = PropUtil.getProperties(propFile);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            propMap.put((String)entry.getKey(), (String)entry.getValue());
        }
        logger.info("props:{}", (Object)StringUtil.toJson(propMap));
    }

    static {
        AppContext.init();
    }
}

