/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.base;

import com.jsmframe.interceptor.MyDateEditor;
import com.jsmframe.pair.Pair;
import com.jsmframe.rest.resp.RestResp;
import com.jsmframe.utils.ExceptionUtil;
import com.jsmframe.utils.JsmFrameUtil;
import com.jsmframe.utils.LogUtil;
import java.beans.PropertyEditor;
import java.util.Date;
import org.slf4j.Logger;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.RestController;

@RestController
public abstract class BaseRest {
    protected Logger logger = LogUtil.log(this.getClass());

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(Date.class, (PropertyEditor)new MyDateEditor());
    }

    @ExceptionHandler(value={Exception.class})
    public RestResp globalExceptionHandler(Exception e) {
        this.logger.error("globalExceptionHandler error.", (Throwable)e);
        return JsmFrameUtil.dealException(e);
    }

    protected void failed(String errorMsg) {
        ExceptionUtil.failed(errorMsg);
    }

    protected void failed(Pair errorPair) {
        ExceptionUtil.failed(errorPair);
    }

    protected void failed(Pair errorPair, String errorMsg) {
        ExceptionUtil.failed(errorPair, errorMsg);
    }

    protected void notFound(String errorMsg) {
        ExceptionUtil.notFound(errorMsg);
    }

    protected void notFound(Pair errorPair) {
        ExceptionUtil.notFound(errorPair);
    }

    protected void notFound(Pair errorPair, String errorMsg) {
        ExceptionUtil.notFound(errorPair, errorMsg);
    }

    protected void info(Pair errorPair) {
        ExceptionUtil.info(errorPair);
    }

    protected void info(String errorMsg) {
        ExceptionUtil.info(errorMsg);
    }

    protected void info(Pair errorPair, String errorMsg) {
        ExceptionUtil.info(errorPair, errorMsg);
    }
}

