/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.auth;

import com.jsmframe.annotation.RestAnn;
import com.jsmframe.auth.Auth;
import com.jsmframe.context.AppContext;
import com.jsmframe.exception.AuthFailException;
import com.jsmframe.exception.NoLoginException;
import com.jsmframe.exception.NoPermissionException;
import com.jsmframe.session.Session;
import com.jsmframe.utils.DateUtil;
import com.jsmframe.utils.EncryptUtil;
import com.jsmframe.utils.LogUtil;
import com.jsmframe.utils.RequestUtil;
import com.jsmframe.utils.StringUtil;
import com.jsmframe.utils.WebUtil;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class WebAuth
implements Auth {
    private Logger logger = LogUtil.log(WebAuth.class);

    @Override
    public String checkAuth(HttpServletRequest request, RestAnn resetAnn, boolean isTry) {
        Session session;
        String token = "";
        if (AppContext.isJedisSession()) {
            String at = RequestUtil.get(request, "at");
            String ht = RequestUtil.get(request, "ht");
            this.logger.debug("checkSession, auth type {},at {}, ht {}", new Object[]{resetAnn.authType(), at, ht});
            token = this.decodeWebToken(at, ht, request);
            if (StringUtil.isEmpty(token)) {
                if (isTry) {
                    return token;
                }
                throw new AuthFailException();
            }
        }
        if ((session = new Session(token)).isExpire()) {
            if (isTry) {
                return token;
            }
            throw new NoLoginException();
        }
        session.live();
        request.setAttribute("jedis_session_key", (Object)session);
        if (!(isTry || StringUtil.isEmpty(resetAnn.permission()) || WebUtil.hasPermissions(resetAnn.permission()))) {
            throw new NoPermissionException();
        }
        return token;
    }

    private String decodeWebToken(String at, String ht, HttpServletRequest request) {
        String token = null;
        try {
            if (!StringUtil.isEmpty(at) && !StringUtil.isEmpty(ht)) {
                String decAuth = EncryptUtil.base64Decode(at);
                if (decAuth == null || !decAuth.contains("_")) {
                    this.logger.error("illegal auth: {}", (Object)at);
                    return null;
                }
                String[] arr = decAuth.split("_");
                token = arr[0];
                String timestamp = arr[1];
                Long cTime = Long.valueOf(timestamp);
                long sTime = DateUtil.currentTime();
                Long res = Math.abs(sTime - cTime);
                Long expireTime = AppContext.getAsLong("at.expire.time");
                if (expireTime == null) {
                    expireTime = 60000L;
                }
                if (res > expireTime) {
                    this.logger.error("sTime {} - cTime {} = {}", new Object[]{sTime, cTime, res});
                    return null;
                }
                String sAuth = EncryptUtil.base64Encode(token + "_" + timestamp);
                if (!sAuth.equals(at)) {
                    this.logger.error("sAt {} != at {}", new Object[]{sAuth, at});
                    return null;
                }
                String sHash = EncryptUtil.md5(token + "_" + timestamp);
                if (!sHash.equals(ht)) {
                    this.logger.error("sHt {} != ht {}", new Object[]{sHash, ht});
                    return null;
                }
            }
            if (AppContext.isDevModel() && StringUtil.isEmpty(token) && !StringUtil.isEmpty(token = RequestUtil.get(request, "jsm-token"))) {
                this.logger.warn("use dev model token:{}", (Object)"jsm-token");
            }
            request.setAttribute("token", token);
        }
        catch (Exception e) {
            this.logger.error("decodeWebToken error!", (Throwable)e);
            return null;
        }
        return token;
    }
}

