/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.auth;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.jsmframe.annotation.RestAnn;
import com.jsmframe.auth.Auth;
import com.jsmframe.context.AppContext;
import com.jsmframe.exception.AuthFailException;
import com.jsmframe.http.HttpClient;
import com.jsmframe.oauth.client.OauthContext;
import com.jsmframe.rest.resp.RestResp;
import com.jsmframe.service.CacheService;
import com.jsmframe.utils.LogUtil;
import com.jsmframe.utils.RequestUtil;
import com.jsmframe.utils.StringUtil;
import java.util.ArrayList;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class ClientAuth
implements Auth {
    private Logger logger = LogUtil.log(ClientAuth.class);
    @Resource
    private CacheService cacheService;
    private String tokenName = AppContext.get("oauth.client.tokenName");
    private String verifyUrl = AppContext.get("oauth.client.verifyUrl");
    private HttpClient httpClient = new HttpClient();

    @Override
    public String checkAuth(HttpServletRequest request, RestAnn resetAnn, boolean isTry) {
        String resourceCode;
        String token = RequestUtil.get(request, this.tokenName);
        boolean res = this.verifyOauthToken(token, resourceCode = resetAnn.permission());
        if (!res) {
            throw new AuthFailException();
        }
        return token;
    }

    private RestResp<String> getVerifyOauthTokenResult(String accessToken, String resourceCode) {
        try {
            if (StringUtil.isEmpty(this.verifyUrl)) {
                this.logger.error("oauth.client.verifyUrl not found, in AppContext!");
                return null;
            }
            ArrayList<Header> headerList = new ArrayList<Header>();
            headerList.add((Header)new BasicHeader(this.tokenName, accessToken));
            String res = this.httpClient.get(headerList, this.verifyUrl);
            this.logger.debug("res:{}", (Object)res);
            if (StringUtil.isEmpty(res)) {
                this.logger.error("get verify token info empty error.");
                return null;
            }
            RestResp resp = (RestResp)JSON.parseObject((String)res, (TypeReference)new TypeReference<RestResp<String>>(){}, (Feature[])new Feature[0]);
            return resp;
        }
        catch (Exception e) {
            this.logger.error("getVerifyOauthTokenResult error:" + this.verifyUrl, (Throwable)e);
            return null;
        }
    }

    private boolean verifyOauthToken(String token, String resourceCode) {
        try {
            String cacheKey = token + "_" + resourceCode;
            RestResp<String> verifyTokenResp = this.cacheService.get(cacheKey, new TypeReference<RestResp<String>>(){});
            if (verifyTokenResp == null) {
                verifyTokenResp = this.getVerifyOauthTokenResult(token, resourceCode);
                Integer expireTime = AppContext.getAsInteger("oauth.client.expireIn");
                if (expireTime == null) {
                    expireTime = 5;
                    this.logger.warn("oauth.client.expireIn not config, use default:{}", (Object)expireTime);
                }
                if (!verifyTokenResp.isOK()) {
                    this.logger.error("verify token failed." + StringUtil.toJson(verifyTokenResp));
                }
                this.cacheService.set(cacheKey, expireTime, verifyTokenResp);
            }
            OauthContext.setAccessToken(token);
            this.logger.debug("setVerifyResult:{}", verifyTokenResp.result);
            OauthContext.setVerifyResult((String)verifyTokenResp.result);
            return verifyTokenResp.isOK();
        }
        catch (Exception e) {
            this.logger.error("verifyOauthToken error!", (Throwable)e);
            return false;
        }
    }
}

