/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.auth;

import com.jsmframe.annotation.RestAnn;
import com.jsmframe.auth.Auth;
import com.jsmframe.context.AppContext;
import com.jsmframe.exception.AuthFailException;
import com.jsmframe.exception.NoLoginException;
import com.jsmframe.exception.NoPermissionException;
import com.jsmframe.session.Session;
import com.jsmframe.utils.BlowFishUtil;
import com.jsmframe.utils.DateUtil;
import com.jsmframe.utils.EncryptUtil;
import com.jsmframe.utils.LogUtil;
import com.jsmframe.utils.RequestUtil;
import com.jsmframe.utils.StringUtil;
import com.jsmframe.utils.WebUtil;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class AppAuth
implements Auth {
    private Logger logger = LogUtil.log(AppAuth.class);

    @Override
    public String checkAuth(HttpServletRequest request, RestAnn resetAnn, boolean isTry) {
        Session session;
        String token = "";
        if (AppContext.isJedisSession()) {
            String at = RequestUtil.get(request, "at");
            String ht = RequestUtil.get(request, "ht");
            this.logger.debug("checkSession, auth type {},at {}, ht {}", new Object[]{resetAnn.authType(), at, ht});
            token = this.decodeAppToken(at, ht, request);
            if (StringUtil.isEmpty(token)) {
                if (isTry) {
                    return token;
                }
                throw new AuthFailException();
            }
        }
        if ((session = new Session(token)).isExpire()) {
            if (isTry) {
                return token;
            }
            throw new NoLoginException();
        }
        session.live();
        request.setAttribute("jedis_session_key", (Object)session);
        if (!(isTry || StringUtil.isEmpty(resetAnn.permission()) || WebUtil.hasPermissions(resetAnn.permission()))) {
            throw new NoPermissionException();
        }
        return token;
    }

    private String decodeAppToken(String at, String ht, HttpServletRequest request) {
        String token = null;
        try {
            if (!StringUtil.isEmpty(at) && !StringUtil.isEmpty(ht)) {
                String decAuth = BlowFishUtil.dec(at);
                if (decAuth == null || !decAuth.contains(",")) {
                    this.logger.error("illegal at: {}", (Object)at);
                    return null;
                }
                String[] arr = decAuth.split(",");
                token = arr[0];
                String timestamp = arr[1];
                Long cTime = Long.valueOf(timestamp);
                long sTime = DateUtil.currentTime();
                Long res = Math.abs(sTime - cTime);
                Long expireTime = AppContext.getAsLong("at.expire.time");
                if (expireTime == null) {
                    expireTime = 60000L;
                }
                if (res > expireTime) {
                    this.logger.error("sTime {} - cTime {} = {}", new Object[]{sTime, cTime, res});
                    return null;
                }
                String sAuth = BlowFishUtil.enc(token + "," + timestamp);
                if (!sAuth.equals(at)) {
                    this.logger.error("sAt {} != at {}", new Object[]{sAuth, at});
                    return null;
                }
                String sHash = EncryptUtil.md5(token + "," + timestamp);
                if (!sHash.equals(at)) {
                    this.logger.error("sHt {} != ht {}", new Object[]{sHash, at});
                    return null;
                }
                request.setAttribute("token", (Object)token);
            }
        }
        catch (Exception e) {
            this.logger.error("decodeAppToken error!", (Throwable)e);
            return null;
        }
        return token;
    }
}

