/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.aop;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.jsmframe.annotation.AuthType;
import com.jsmframe.annotation.OrderAnn;
import com.jsmframe.annotation.RestAnn;
import com.jsmframe.annotation.Transaction;
import com.jsmframe.auth.AppAuth;
import com.jsmframe.auth.Auth;
import com.jsmframe.auth.WebAuth;
import com.jsmframe.base.ValidateModel;
import com.jsmframe.consts.BasePairConsts;
import com.jsmframe.context.AppContext;
import com.jsmframe.context.SpringContext;
import com.jsmframe.context.WebContext;
import com.jsmframe.dao.model.OptLog;
import com.jsmframe.db.DynamicDataSourceHolder;
import com.jsmframe.exception.BaseException;
import com.jsmframe.exception.InfoException;
import com.jsmframe.jedis.JedisService;
import com.jsmframe.order.BaseOrderLine;
import com.jsmframe.pair.Pair;
import com.jsmframe.rest.resp.ExcelResp;
import com.jsmframe.rest.resp.FileResp;
import com.jsmframe.rest.resp.FreeResp;
import com.jsmframe.rest.resp.HtmlResp;
import com.jsmframe.rest.resp.JsonResp;
import com.jsmframe.rest.resp.RestResp;
import com.jsmframe.rest.resp.TextResp;
import com.jsmframe.rest.resp.XmlResp;
import com.jsmframe.service.LogService;
import com.jsmframe.session.Session;
import com.jsmframe.session.SessionUser;
import com.jsmframe.stat.model.Alarm;
import com.jsmframe.utils.EncryptUtil;
import com.jsmframe.utils.HttpClientUtil;
import com.jsmframe.utils.IpUtil;
import com.jsmframe.utils.JsmFrameUtil;
import com.jsmframe.utils.LogUtil;
import com.jsmframe.utils.RequestUtil;
import com.jsmframe.utils.ResponseUtil;
import com.jsmframe.utils.StringUtil;
import com.jsmframe.utils.SystemUtil;
import com.jsmframe.utils.TemplateUtil;
import com.jsmframe.utils.TransactionUtil;
import com.jsmframe.utils.ValidateUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Date;
import javax.annotation.Resource;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@Aspect
@Component
public class RestAop {
    private static Logger logger = LogUtil.log(RestAop.class);
    private PlatformTransactionManager transactionManager;
    @Resource
    private JedisService jedisService;
    @Resource
    private WebAuth webAuth;
    @Resource
    private AppAuth appAuth;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(restAnn)")
    public Object intercept(ProceedingJoinPoint jpt, RestAnn restAnn) throws Throwable {
        Pair<String> resPair;
        Object result = null;
        Method method = ((MethodSignature)jpt.getSignature()).getMethod();
        OrderAnn orderAnn = method.getAnnotation(OrderAnn.class);
        if (orderAnn != null && !(resPair = this.orderCheck(jpt, orderAnn)).equals(BasePairConsts.ACTIVITY_TURN)) {
            throw new InfoException(resPair);
        }
        boolean useMock = false;
        try {
            boolean outputed;
            String jsmMock = RequestUtil.getParameter(WebContext.getRequest(), "jsm_mock");
            if (AppContext.isDevModel() && !StringUtil.isEmpty(jsmMock)) {
                useMock = true;
                String res = JsmFrameUtil.genMockResult(method);
                logger.warn("mock resp:{}", (Object)res);
                Object object = JSON.parseObject((String)res, (Type)method.getGenericReturnType(), (Feature[])new Feature[0]);
                return object;
            }
            if (restAnn.internal() && !IpUtil.isInternalIp(WebContext.getFirstForwardIp())) {
                throw new InfoException(BasePairConsts.NET_LIMIT);
            }
            if (!StringUtil.isEmpty(restAnn.ipCheckKey()) && !IpUtil.checkRemoteIp(WebContext.getFirstForwardIp(), restAnn.ipCheckKey())) {
                throw new InfoException(BasePairConsts.IP_LIMIT);
            }
            String authId = this.validateAuth(jpt, restAnn);
            this.validateParams(jpt, restAnn);
            this.repeatCheck(jpt, restAnn, authId);
            if (restAnn.sync()) {
                Method method2 = method;
                synchronized (method2) {
                    result = this.process(jpt, restAnn);
                }
            } else {
                result = this.process(jpt, restAnn);
            }
            if (!useMock) {
                this.logRecord(restAnn);
            }
            if (outputed = this.outputResult(result)) {
                result = null;
            }
        }
        catch (Exception e) {
            RestResp errorResp;
            RestResp restResp = errorResp = JsmFrameUtil.dealException(e);
            return restResp;
        }
        finally {
            boolean outputed;
            if (!useMock) {
                this.logRecord(restAnn);
            }
            if (outputed = this.outputResult(result)) {
                result = null;
            }
        }
        return result;
    }

    private Pair<String> orderCheck(ProceedingJoinPoint jpt, OrderAnn orderAnn) {
        String key = orderAnn.productKey();
        key = StringUtil.isEmpty(key) ? this.getKey(jpt) : TemplateUtil.formatWithContextVar(key);
        BaseOrderLine orderLine = (BaseOrderLine)SpringContext.getBean(orderAnn.type().t());
        return orderLine.order(key, orderAnn);
    }

    private String getKey(ProceedingJoinPoint jpt) {
        StringBuilder sb = new StringBuilder();
        sb.append(jpt.toString());
        for (Object o : jpt.getArgs()) {
            sb.append("|").append(o.hashCode());
        }
        return sb.toString();
    }

    private String validateAuth(ProceedingJoinPoint jpt, RestAnn resetAnn) {
        String authId = null;
        if (resetAnn.authType() != AuthType.NONE) {
            Auth auth = (Auth)SpringContext.getBean(resetAnn.authType().t());
            if (auth == null) {
                logger.error("authBean not found.{}", (Object)resetAnn.authType().t());
            } else {
                logger.debug("authBean:{}", (Object)resetAnn.authType().t());
                authId = auth.checkAuth(WebContext.getRequest(), resetAnn, false);
            }
        } else if (AppContext.isJedisSession()) {
            String at = RequestUtil.get(WebContext.getRequest(), "at");
            String ht = RequestUtil.get(WebContext.getRequest(), "ht");
            String token = RequestUtil.get(WebContext.getRequest(), "jsm-token");
            if ((StringUtil.isEmpty(at) && StringUtil.isEmpty(ht) || AppContext.isDevModel() && !StringUtil.isEmpty(token)) && StringUtil.isEmpty(authId = this.webAuth.checkAuth(WebContext.getRequest(), resetAnn, true))) {
                authId = this.appAuth.checkAuth(WebContext.getRequest(), resetAnn, true);
            }
        }
        return authId;
    }

    private boolean outputResult(Object result) {
        boolean output = true;
        if (result instanceof RestResp) {
            WebContext.getRequest().setAttribute("jsm-resp-code", ((RestResp)result).code);
            if (result instanceof RestResp) {
                logger.info("resp:" + StringUtil.toJson(result));
            }
        }
        try {
            if (result instanceof FileResp) {
                ResponseUtil.outputFile(WebContext.getResponse(), (FileResp)result);
            } else if (result instanceof TextResp) {
                ResponseUtil.outputText(WebContext.getResponse(), (TextResp)result);
            } else if (result instanceof JsonResp) {
                ResponseUtil.outputJson(WebContext.getResponse(), (JsonResp)result);
            } else if (result instanceof XmlResp) {
                ResponseUtil.outputXml(WebContext.getResponse(), (XmlResp)result);
            } else if (result instanceof HtmlResp) {
                ResponseUtil.outputHtml(WebContext.getResponse(), (HtmlResp)result);
            } else if (result instanceof ExcelResp) {
                ResponseUtil.outputExcel(WebContext.getResponse(), (ExcelResp)result);
            } else if (result instanceof FreeResp) {
                ResponseUtil.outputFreeResp(WebContext.getResponse(), (FreeResp)result);
            } else if (result instanceof String) {
                String res = (String)result;
                logger.info("respString: {}", (Object)res);
                if (res.startsWith("redirect:")) {
                    WebContext.getResponse().sendRedirect(res.substring(9));
                } else if (res.startsWith("forward:")) {
                    HttpServletRequest request = WebContext.getRequest();
                    HttpServletResponse response = WebContext.getResponse();
                    request.getRequestDispatcher(res.substring(8)).forward((ServletRequest)request, (ServletResponse)response);
                } else {
                    logger.warn("unknown Resp String!");
                    output = false;
                }
            } else {
                output = false;
            }
        }
        catch (Exception e) {
            logger.error("outputResult error.", (Throwable)e);
        }
        return output;
    }

    private void repeatCheck(ProceedingJoinPoint jpt, RestAnn resetAnn, String authId) {
        boolean isRepeat;
        if ((WebContext.isRequestMethod("POST") || WebContext.isRequestMethod("PUT")) && resetAnn.repeatCheck() && (isRepeat = this.isRepeatRequest(jpt, authId))) {
            throw new InfoException(BasePairConsts.REPEAT_REQ_ERROR);
        }
    }

    private void validateParams(ProceedingJoinPoint jpt, RestAnn resetAnn) {
        String message;
        if (resetAnn.validate() && !StringUtil.isEmpty(message = this.validate(jpt))) {
            throw new InfoException(BasePairConsts.PARAMS_ERROR, message);
        }
    }

    private void logRecord(RestAnn resetAnn) {
        if (!StringUtil.isEmpty(resetAnn.log())) {
            OptLog optLog = new OptLog();
            optLog.ip = WebContext.getRemoteIp();
            Session session = WebContext.currentSession();
            optLog.mac = session != null ? (String)session.get("mac") : "";
            optLog.funcName = resetAnn.logType();
            SessionUser sessionUser = WebContext.currentUser();
            optLog.uid = sessionUser != null ? sessionUser.getUid().toString() : null;
            optLog.optDesc = TemplateUtil.formatWithContextVar(resetAnn.log());
            optLog.time = new Date();
            LogService logService = SpringContext.getBean(LogService.class);
            String loggerUrl = AppContext.get("logger.url");
            if (logService != null) {
                DynamicDataSourceHolder.setDataSource(false);
                logService.addLog(optLog);
            } else if (StringUtil.isEmpty(loggerUrl)) {
                HttpClientUtil.post(loggerUrl, optLog);
            } else {
                logger.error("LogService or logger.url not found! you can implement LogService Or add a logger.url in app.properties");
            }
        }
    }

    private boolean isRepeatRequest(ProceedingJoinPoint jpt, String authId) {
        Method method = ((MethodSignature)jpt.getSignature()).getMethod();
        Object[] args = jpt.getArgs();
        if (args != null && args.length > 0) {
            for (Object arg : args) {
                if (arg == null || !(arg instanceof ValidateModel)) continue;
                String reqMd5 = EncryptUtil.md5(StringUtil.toJson(arg));
                String res = this.jedisService.setnx(method.getName() + "_" + reqMd5 + "_" + authId, 5, "1");
                if ("OK".equals(res)) continue;
                return true;
            }
        }
        return false;
    }

    private Object process(ProceedingJoinPoint jpt, RestAnn resetAnn) throws Throwable {
        Object result = null;
        TransactionStatus status = null;
        String clusterSyncLock = resetAnn.clusterSyncLock();
        try {
            clusterSyncLock = TemplateUtil.formatWithContextVar(clusterSyncLock);
            if (!StringUtil.isEmpty(clusterSyncLock) && this.jedisService != null) {
                this.jedisService.lock(clusterSyncLock);
            }
            DynamicDataSourceHolder.setDataSource(false);
            if (!resetAnn.transaction().equals((Object)Transaction.NONE)) {
                DynamicDataSourceHolder.setDataSource(resetAnn.transaction().equals((Object)Transaction.READ));
                this.transactionManager = (PlatformTransactionManager)SpringContext.getBean(resetAnn.transManagerName());
                status = this.transactionManager.getTransaction((TransactionDefinition)this.createTransactionDefinition(resetAnn));
                TransactionUtil.setTransactionStatus(status);
            }
            result = jpt.proceed();
            if (status != null && !status.isCompleted()) {
                if (status.isRollbackOnly()) {
                    logger.warn("transaction rollback!");
                    this.transactionManager.rollback(status);
                } else {
                    this.transactionManager.commit(status);
                }
            }
        }
        catch (Exception e) {
            if (status != null) {
                logger.error("error: transaction rollback!");
                this.transactionManager.rollback(status);
            }
            if (!(e instanceof BaseException)) {
                SystemUtil.addAlarm(new Alarm("RestAop", "Exception," + e.getMessage()));
            }
            throw e;
        }
        finally {
            TransactionUtil.removeTransactionStatus();
            if (!StringUtil.isEmpty(clusterSyncLock) && this.jedisService != null) {
                this.jedisService.unlock(clusterSyncLock);
            }
        }
        return result;
    }

    private String validate(ProceedingJoinPoint jpt) {
        String message = null;
        Object[] args = jpt.getArgs();
        if (args != null && args.length > 0) {
            for (Object arg : args) {
                if (arg == null) continue;
                if (arg instanceof ValidateModel) {
                    logger.info("request arg:{}", (Object)StringUtil.toJson(arg));
                    message = ValidateUtil.validate(arg);
                    if (StringUtil.isEmpty(message)) continue;
                    break;
                }
                logger.info("request arg type:{}", (Object)arg.getClass().getName());
            }
        }
        return message;
    }

    private DefaultTransactionDefinition createTransactionDefinition(RestAnn restAnn) {
        DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
        transactionDefinition.setPropagationBehavior(restAnn.transPropagationBehavior());
        transactionDefinition.setIsolationLevel(restAnn.transIsolationLevel());
        transactionDefinition.setReadOnly(restAnn.transaction().equals((Object)Transaction.READ));
        transactionDefinition.setTimeout(restAnn.transTimeout());
        return transactionDefinition;
    }
}

