/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.aop;

import com.jsmframe.annotation.ClusterLockAnn;
import com.jsmframe.jedis.JedisService;
import com.jsmframe.utils.LogUtil;
import com.jsmframe.utils.StringUtil;
import com.jsmframe.utils.TemplateUtil;
import com.jsmframe.utils.TransactionUtil;
import javax.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ClusterLockAop {
    private static Logger logger = LogUtil.log(ClusterLockAop.class);
    @Resource
    private JedisService jedisService;

    @Around(value="@annotation(clusterLockAnn)")
    public Object intercept(ProceedingJoinPoint jpt, ClusterLockAnn clusterLockAnn) throws Throwable {
        String key;
        Object result = null;
        if (TransactionUtil.getTransactionStatus() != null) {
            logger.warn("ClusterLockAnn not recommend run in transaction. it's may be make db lock.");
        }
        key = StringUtil.isEmpty(key = clusterLockAnn.value()) ? this.getKey(jpt) : TemplateUtil.formatWithContextVar(key);
        try {
            logger.debug("clusterLockAnn lock:{}", (Object)key);
            boolean locked = this.jedisService.lock(key);
            if (!locked) {
                logger.error("clusterLockAnn lock:{} failed, return.", (Object)key);
                Object object = result;
                return object;
            }
            result = jpt.proceed();
        }
        catch (Exception e) {
            logger.error("clusterLockAnn error,lock key:" + key);
            throw e;
        }
        finally {
            this.jedisService.unlock(key);
            logger.debug("clusterLockAnn unlock:{}", (Object)key);
        }
        return result;
    }

    private String getKey(ProceedingJoinPoint jpt) {
        StringBuilder sb = new StringBuilder();
        sb.append(jpt.toString());
        for (Object o : jpt.getArgs()) {
            sb.append("|").append(o.hashCode());
        }
        return sb.toString();
    }
}

