/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.aop;

import com.jsmframe.annotation.ClusterJobLockAnn;
import com.jsmframe.context.AppContext;
import com.jsmframe.context.WebContext;
import com.jsmframe.jedis.JedisService;
import com.jsmframe.stat.model.Alarm;
import com.jsmframe.utils.LogUtil;
import com.jsmframe.utils.StringUtil;
import com.jsmframe.utils.SystemUtil;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ClusterJobLockAop {
    private static Logger logger = LogUtil.log(ClusterJobLockAop.class);
    private String clusterId = AppContext.get("cluster.id");
    private AtomicInteger reqIdAi = new AtomicInteger(0);
    @Resource
    private JedisService jedisService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(clusterJobLockAnn)")
    public Object intercept(ProceedingJoinPoint jpt, ClusterJobLockAnn clusterJobLockAnn) throws Throwable {
        Object result = null;
        String key = clusterJobLockAnn.value();
        if (StringUtil.isEmpty(key)) {
            key = this.getKey(jpt);
        }
        try {
            logger.debug("clusterJobLockAnn lock:{}", (Object)key);
            boolean locked = this.jedisService.lock(key, 0, clusterJobLockAnn.nextTime());
            if (!locked) {
                logger.warn("clusterJobLockAnn lock:{} failed, return.", (Object)key);
                Object object = result;
                return object;
            }
            int intCount = this.reqIdAi.getAndIncrement();
            if (intCount + 100 > Integer.MAX_VALUE) {
                this.reqIdAi.set(0);
            }
            WebContext.setRequestId(String.format("job-%s-%s-%s", this.clusterId, key, intCount));
            result = jpt.proceed();
        }
        catch (Exception e) {
            logger.error("clusterJobLockAnn error,clusterJobLockAnn key:" + key, (Throwable)e);
            SystemUtil.addAlarm(new Alarm("ClusterJobLockAop", key + ":Exception," + e.getMessage()));
        }
        finally {
            WebContext.clearRequestId();
        }
        return result;
    }

    private String getKey(ProceedingJoinPoint jpt) {
        StringBuilder sb = new StringBuilder();
        sb.append(jpt.toString());
        for (Object o : jpt.getArgs()) {
            sb.append("|").append(o.hashCode());
        }
        return sb.toString();
    }
}

