/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.aop;

import com.jsmframe.annotation.CacheAnn;
import com.jsmframe.annotation.CacheType;
import com.jsmframe.context.AppContext;
import com.jsmframe.context.SpringContext;
import com.jsmframe.jedis.JedisService;
import com.jsmframe.service.CacheService;
import com.jsmframe.utils.LogUtil;
import com.jsmframe.utils.StringUtil;
import com.jsmframe.utils.TemplateUtil;
import java.io.Serializable;
import java.lang.reflect.Method;
import javax.annotation.Resource;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class CacheAop {
    private static Logger logger = LogUtil.log(CacheAop.class);
    @Resource
    private JedisService jedisService;
    @Resource
    private CacheService cacheService;
    private Cache queryCache;

    @Around(value="@annotation(cacheAnn)")
    public Object intercept(ProceedingJoinPoint jpt, CacheAnn cacheAnn) throws Throwable {
        Object result = null;
        Method method = ((MethodSignature)jpt.getSignature()).getMethod();
        if (method.getReturnType().getName().equals("void")) {
            return jpt.proceed();
        }
        if (cacheAnn.cacheType().equals((Object)CacheType.EHCACHE)) {
            result = this.ehcache(jpt, cacheAnn);
        } else if (cacheAnn.cacheType().equals((Object)CacheType.REDIS)) {
            result = this.jedisCache(jpt, cacheAnn);
        } else if (cacheAnn.cacheType().equals((Object)CacheType.EHCACHE_REDIS)) {
            result = this.ehRedisCache(jpt, cacheAnn);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object ehRedisCache(ProceedingJoinPoint jpt, CacheAnn cacheAnn) throws Throwable {
        Method method;
        String key = cacheAnn.cacheKey();
        key = StringUtil.isEmpty(key) ? this.getKey(jpt) : TemplateUtil.formatWithContextVar(key);
        Object result = this.cacheService.get(key, (method = ((MethodSignature)jpt.getSignature()).getMethod()).getGenericReturnType());
        if (result == null) {
            ProceedingJoinPoint proceedingJoinPoint = jpt;
            synchronized (proceedingJoinPoint) {
                result = this.cacheService.get(key, method.getGenericReturnType());
                if (result == null) {
                    result = jpt.proceed();
                    this.cacheService.set(key, cacheAnn.expireSeconds(), (Serializable)result);
                    logger.debug("update ehRedisCache key: " + key);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object jedisCache(ProceedingJoinPoint jpt, CacheAnn cacheAnn) throws Throwable {
        Object result = null;
        String key = cacheAnn.cacheKey();
        key = StringUtil.isEmpty(key) ? this.getKey(jpt) : TemplateUtil.formatWithContextVar(key);
        int expireTime = cacheAnn.expireSeconds();
        String jresult = this.jedisService.get(key);
        if (jresult == null) {
            ProceedingJoinPoint proceedingJoinPoint = jpt;
            synchronized (proceedingJoinPoint) {
                jresult = this.jedisService.get(key);
                if (jresult == null) {
                    result = jpt.proceed();
                    this.jedisService.setex(key, expireTime, StringUtil.toJson(result));
                    logger.debug("update jedisCache key: " + key);
                } else {
                    result = this.parseReturnObject(jpt, jresult);
                }
            }
        } else {
            result = this.parseReturnObject(jpt, jresult);
        }
        return result;
    }

    private Object parseReturnObject(ProceedingJoinPoint jpt, String jresult) {
        Method method = ((MethodSignature)jpt.getSignature()).getMethod();
        Object result = StringUtil.parseObject(jresult, method.getGenericReturnType());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object ehcache(ProceedingJoinPoint jpt, CacheAnn cacheAnn) throws Throwable {
        Object result = null;
        String key = cacheAnn.cacheKey();
        key = StringUtil.isEmpty(key) ? this.getKey(jpt) : TemplateUtil.formatWithContextVar(key);
        Element element = this.getQueryCache().get((Serializable)((Object)key));
        if (element == null) {
            ProceedingJoinPoint proceedingJoinPoint = jpt;
            synchronized (proceedingJoinPoint) {
                element = this.getQueryCache().get((Serializable)((Object)key));
                if (element == null) {
                    result = jpt.proceed();
                    this.getQueryCache().put(new Element((Serializable)((Object)key), (Serializable)result));
                    logger.debug("update ehcache key: " + key);
                } else {
                    result = element.getObjectValue();
                }
            }
        } else {
            result = element.getObjectValue();
        }
        return result;
    }

    private Cache getQueryCache() {
        if (this.queryCache == null) {
            String ehcacheName = AppContext.get("cache.service.cache.name");
            if (StringUtil.isEmpty(ehcacheName)) {
                ehcacheName = "queryCache";
            }
            this.queryCache = (Cache)SpringContext.getBean(ehcacheName);
        }
        return this.queryCache;
    }

    private String getKey(ProceedingJoinPoint jpt) {
        StringBuilder sb = new StringBuilder();
        sb.append(jpt.toString());
        for (Object o : jpt.getArgs()) {
            sb.append("|").append(o.hashCode());
        }
        return sb.toString();
    }
}

