package com.jsmframe.utils;

import com.jsmframe.context.AppContext;
import org.slf4j.Logger;
import sun.net.util.IPAddressUtil;

public class IpUtil {

    private static Logger logger = LogUtil.log(IpUtil.class);

    private String ENABLE_CMD = "iptables -D INPUT -s %s -j DROP";
    private String DISABLE_CMD = "iptables -I INPUT -s %s -j DROP";

    public static boolean checkRemoteIp(String remoteIp, String contextKey) {
        String ips = AppContext.get(contextKey);
        if (StringUtil.isEmpty(ips)) {
            return false;
        }
        return ips.contains(remoteIp);
    }

    /**
     * 禁IP
     *
     * @param ip
     */
    public boolean disableIp(String ip) {
        return checkAndExec(ip, DISABLE_CMD);
    }

    /**
     * 解禁IP
     *
     * @param ip
     */
    public boolean enableIp(String ip) {
        return checkAndExec(ip, ENABLE_CMD);
    }

    private boolean checkAndExec(String ip, String disable_cmd) {
        if (!SystemUtil.IS_OS_UNIX) {
            logger.error("not unix ,can't run shell.");
            return false;
        }
        if (!StringUtil.isIpv4(ip)) {
            logger.error("is not a ip:{}", ip);
            return false;
        }

        String cmd = String.format(disable_cmd, ip);
        ShellUtil.exec(cmd);
        return true;
    }


    public static boolean isInternalIp(String ip) {
        byte[] addr = IPAddressUtil.textToNumericFormatV4(ip);
        return isInternalIp(addr);
    }


    public static boolean isInternalIp(byte[] addr) {
        final byte b0 = addr[0];
        final byte b1 = addr[1];
        //10.x.x.x/8
        final byte SECTION_1 = 0x0A;
        //172.16.x.x/12
        final byte SECTION_2 = (byte) 0xAC;
        final byte SECTION_3 = (byte) 0x10;
        final byte SECTION_4 = (byte) 0x1F;
        //192.168.x.x/16
        final byte SECTION_5 = (byte) 0xC0;
        final byte SECTION_6 = (byte) 0xA8;
        switch (b0) {
            case SECTION_1:
                return true;
            case SECTION_2:
                if (b1 >= SECTION_3 && b1 <= SECTION_4) {
                    return true;
                }
            case SECTION_5:
                switch (b1) {
                    case SECTION_6:
                        return true;
                }
            default:
                return false;

        }
    }


}
