package com.jsmframe.swagger;

import com.jsmframe.context.AppContext;
import com.jsmframe.context.WebContext;
import com.jsmframe.utils.LogUtil;
import com.jsmframe.utils.StringUtil;
import org.slf4j.Logger;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Parameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

import java.util.ArrayList;
import java.util.List;

@EnableWebMvc
@EnableSwagger2
@Configuration
public class SwaggerConfig extends WebMvcConfigurationSupport {

    protected Logger logger = LogUtil.log(getClass());
	private boolean swaggerEnable = StringUtil.toBoolean(AppContext.get("swagger.enable"));
	private String swaggerPackage = AppContext.get("swagger.apis.package");
	private String swaggerTitle = AppContext.get("swagger.apis.title");
	private String swaggerVersion = AppContext.get("swagger.apis.version");
	private String swaggerDescription = AppContext.get("swagger.apis.description");
	private String swaggerHeaders = AppContext.get("swagger.apis.headers");

    @Bean
    public Docket createRestApi() {
		logger.info("swaggerEnable:{} ",swaggerEnable);
		logger.info("swaggerPackage:{} ",swaggerPackage);
		logger.info("swaggerTitle:{} ",swaggerTitle);
		logger.info("swaggerVersion:{} ",swaggerVersion);
		logger.info("swaggerDescription:{} ",swaggerDescription);
		logger.info("swaggerHeaders:{} ",swaggerHeaders);
        ApiInfo apiInfo = apiInfo();
        List<Parameter> params = new ArrayList<Parameter>();
        params.add(new Parameter(WebContext.JSM_MOCK, "", "", false, false, new ModelRef("String"), null, null, "query", null, false, null));
        if(!StringUtil.isEmpty(swaggerHeaders)){
            String[] headersArr = swaggerHeaders.split(";");
            for(String header:headersArr){
                String[] headeArr = header.split("\\|");
                params.add(new Parameter(headeArr[0], "", "", false, false, new ModelRef("String"), null, null, "header", null, false, null));
            }
        }
        return new Docket(DocumentationType.SWAGGER_2)
                .apiInfo(apiInfo)
                .enable(swaggerEnable)
                .globalOperationParameters(params)
                .select()
                .apis(RequestHandlerSelectors.basePackage(swaggerPackage))
                .paths(PathSelectors.any())
                .build();
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder()
                .title(swaggerTitle)
                .version(swaggerVersion)
                .description(swaggerDescription)
                .build();
    }

}