package com.jsmframe.stat.model;

import com.jsmframe.annotation.FieldAnn;
import com.jsmframe.base.BaseModel;
import com.jsmframe.base.ValidateModel;
import com.jsmframe.context.AppContext;

public class SystemStat implements ValidateModel {
    @FieldAnn(required = false, maxLen = 20, comments = "操作系统版本")
    public String osVersion;
    @FieldAnn(required = false, maxLen = 50, comments = "操作系统类型")
    public String osType;
    @FieldAnn(required = false, maxLen = 50, comments = "用户")
    public String userName;
    @FieldAnn(required = false, maxLen = 50, comments = "目录")
    public String userDir;
    @FieldAnn(required = false, maxLen = 50, comments = "临时目录")
    public String tmpDir;
    @FieldAnn(required = false, maxLen = 50, comments = "运行环境名")
    public String runtimeName;
    @FieldAnn(required = false, maxLen = 50, comments = "运行环境版本")
    public String runtimeVersion;
    @FieldAnn(required = false, maxLen = 50, comments = "JVM名")
    public String jvmName;
    @FieldAnn(required = false, maxLen = 50, comments = "JVM版本")
    public String jvmVersion;
    @FieldAnn(required = false, comments = "总内存")
    public Long totalMemory;
    @FieldAnn(required = false, comments = "剩余内存")
    public Long freeMemory;
    @FieldAnn(required = false, comments = "已用内存")
    public Long useMemory;
    @FieldAnn(required = false, comments = "CPU使用率")
    public Integer cpuRatio;
    @FieldAnn(required = false, comments = "线程数")
    public Integer threadCount;
    @FieldAnn(required = false, maxLen = 50, comments = "服务ID")
    public String clusterId;

}
