package com.jsmframe.stat.model;

import com.jsmframe.annotation.FieldAnn;
import com.jsmframe.base.ValidateModel;
import com.jsmframe.context.AppContext;
import com.jsmframe.context.WebContext;
import com.jsmframe.utils.DateUtil;

import java.util.Date;

public class Alarm implements ValidateModel {
    @FieldAnn(required = false, comments = "发生时间")
    public Date time;
    @FieldAnn(required = false, comments = "级别 0 ERROR 1 WARN 2 INFO 3 DEBUG")
    public int level;
    @FieldAnn(required = false, maxLen = 50, comments = "名称")
    public String name;
    @FieldAnn(required = false, maxLen = 100, comments = "描述")
    public String comments;
    @FieldAnn(required = false, maxLen = 50, comments = "请求ID")
    public String reqId;
    @FieldAnn(required = false, maxLen = 50, comments = "服务ID")
    public String clusterId;

    public Alarm(int level, String name, String comments) {
        this.time = new Date();
        this.level = level;
        this.name = name;
        this.comments = comments;
        this.reqId = WebContext.getRequestId();
        this.clusterId = AppContext.get("cluster.id");
    }

    public Alarm(String name, String comments) {
        this.time = new Date();
        this.level = 0;
        this.name = name;
        this.comments = comments;
        this.reqId = WebContext.getRequestId();
        this.clusterId = AppContext.get("cluster.id");
    }

    public Alarm() {
        this.time = new Date();
        this.level = 0;
        this.reqId = WebContext.getRequestId();
        this.clusterId = AppContext.get("cluster.id");
    }
}
