package com.jsmframe.service;

import com.jsmframe.annotation.OrderAnn;
import com.jsmframe.consts.BasePairConsts;
import com.jsmframe.jedis.JedisCmd;
import com.jsmframe.jedis.JedisService;
import com.jsmframe.jedis.ShardedJedisCmd;
import com.jsmframe.order.BaseOrderLine;
import com.jsmframe.pair.Pair;
import com.jsmframe.utils.TemplateUtil;
import redis.clients.jedis.ShardedJedis;

import javax.annotation.Resource;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class FairLineService extends BaseOrderLine {

    @Resource
    private JedisService jedisService;

    private AtomicLong seed = new AtomicLong();

    @Override
    public Pair<String> order(String key, OrderAnn orderAnn) {

        if (getStatus().equals(BasePairConsts.ACTIVITY_NOT_STARTED) || getStatus().equals(BasePairConsts.ACTIVITY_OVER)) {
            return getStatus();
        }
        String member = TemplateUtil.formatWithContextVar(orderAnn.userKey());;
        Long idx = jedisService.exec(new ShardedJedisCmd<Long>() {
            @Override
            public Long run(ShardedJedis shardedJedis) throws Exception {
                Long idx = shardedJedis.zrank(key, member);
                if (idx == null) {//加入
                    shardedJedis.zadd(key, seed.incrementAndGet(), member);
                } else {//更新
                    shardedJedis.zincrby(key, -1, member);
                }
                return shardedJedis.zrank(key, member);
            }
        });
        if (idx == 0) {
            return BasePairConsts.ACTIVITY_TURN;
        } else {
            return BasePairConsts.ACTIVITY_QUEUEING;
        }
    }
}
